/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.channel;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.migration.business.UserGroupMembershipsImportPublisher;
import de.justsoftware.onx.migration.integration.persistence.MigrationMappingDAO;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonRolesMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(PersonRolesMigrationService.class);
    private static final String PERSON_ROLE_MIGRATION = "PERSON_ROLE_MIGRATION";
    private final PersonRoleService _personRoleService;
    private final EntityService _entityService;
    private final PeopleInternalApiConnector _peopleInternalApiConnector;
    private final MigrationMappingDAO _migrationMappingDAO;
    private final UserGroupMembershipsImportPublisher _userGroupMembershipsImportPublisher;
    private final PersonService _personService;

    @Autowired
    public PersonRolesMigrationService(PersonRoleService personRoleService, EntityService entityService, PeopleInternalApiConnector peopleInternalApiConnector, MigrationMappingDAO migrationMappingDAO, UserGroupMembershipsImportPublisher userGroupMembershipsImportPublisher, PersonService personService) {
        this._personRoleService = personRoleService;
        this._entityService = entityService;
        this._peopleInternalApiConnector = peopleInternalApiConnector;
        this._migrationMappingDAO = migrationMappingDAO;
        this._userGroupMembershipsImportPublisher = userGroupMembershipsImportPublisher;
        this._personService = personService;
    }

    @Nonnull
    public ImmutableSetMultimap<DBPrivacyType, String> getRolesForChannel(EntityId entityId) {
        DBEntity channelEntity = this._entityService.getByIdNotNull(entityId);
        return this.getRelevantTypes(channelEntity);
    }

    private ImmutableSetMultimap<DBPrivacyType, String> getRelevantTypes(DBEntity dbEntity) {
        EntityItem item = new EntityItem(dbEntity);
        return this._entityService.getPrivacySelectedAuthorityNames(item, (Set<DBPrivacyType>)ImmutableSet.of((Object)((Object)DBPrivacyType.VISIBILITY), (Object)((Object)DBPrivacyType.ENTITY_EDIT)));
    }

    public ImmutableSetMultimap<DBPrivacyType, String> getPersonRolesForChannel(EntityId entityId) {
        ArrayList<String> availablePersonRoles = new ArrayList<String>((Collection<String>)this._personRoleService.getVisibleRoleNames());
        ImmutableSetMultimap<DBPrivacyType, String> rolesForChannel = this.getRolesForChannel(entityId);
        ImmutableSet visibilityRoles = rolesForChannel.get((Object)DBPrivacyType.VISIBILITY);
        ImmutableSet editRoles = rolesForChannel.get((Object)DBPrivacyType.ENTITY_EDIT);
        ImmutableSetMultimap.Builder personRolesForChannel = ImmutableSetMultimap.builder();
        availablePersonRoles.removeAll(List.of("SUPERADMIN", "TRANSLATOR", "BACKENDADMIN"));
        personRolesForChannel.putAll((Object)DBPrivacyType.VISIBILITY, (Iterable)visibilityRoles.stream().filter(availablePersonRoles::contains).collect(Collectors.toList()));
        personRolesForChannel.putAll((Object)DBPrivacyType.ENTITY_EDIT, (Iterable)editRoles.stream().filter(availablePersonRoles::contains).collect(Collectors.toList()));
        return personRolesForChannel.build();
    }

    public UserGroupId getUserGroupForRole(TenantId tenantId, String role) {
        ImmutableSet<String> tenantRoleUserGroup = this._migrationMappingDAO.getByNameAndKey(PERSON_ROLE_MIGRATION, role);
        if (!tenantRoleUserGroup.isEmpty()) {
            return UserGroupId.parseOrThrow((String)tenantRoleUserGroup.stream().iterator().next());
        }
        UserGroupId userGroupId = this._peopleInternalApiConnector.createUserGroupFromPersonRoleForMigration(role + "_migriert", tenantId);
        this._migrationMappingDAO.insertMapping(PERSON_ROLE_MIGRATION, role, userGroupId.toString());
        LOG.info("Usergroup {} for person role {} created", (Object)userGroupId, (Object)role);
        return userGroupId;
    }

    public void exportPeopleToUserGroups() {
        ImmutableSetMultimap<String, String> migratedRoles = this._migrationMappingDAO.getByName(PERSON_ROLE_MIGRATION);
        if (!migratedRoles.isEmpty()) {
            migratedRoles.forEach((role, usergroup) -> {
                List<PersonId> personIds = this._personService.getPersonIdsByRole(List.of(role));
                for (PersonId personId : personIds) {
                    this._userGroupMembershipsImportPublisher.addProfileIdToUserGroup(personId.asProfileId(), UserGroupId.parseOrThrow(usergroup));
                }
                LOG.info("Added {} personIds in usergroup {}", (Object)personIds.size(), usergroup);
            });
        }
    }
}

