/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.channel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.news.migration.CustomNanoId;
import de.justsoftware.onx.news.migration.NewsMigrationDAO;
import de.justsoftware.onx.news.migration.channel.ChannelKafkaDto;
import de.justsoftware.onx.news.migration.channel.ChannelMigrationDAO;
import de.justsoftware.onx.news.migration.channel.ChannelPermissionKafkaDto;
import de.justsoftware.onx.news.migration.channel.ChannelSubscriptionKafkaDto;
import de.justsoftware.onx.news.migration.channel.PersonRolesMigrationService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
@ParametersAreNonnullByDefault
public class ChannelMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelMigrationService.class);
    private static final String MANAGER = "MANAGER";
    private static final String WRITER = "WRITER";
    private static final String READER = "READER";
    private static final String CHANNEL = "CHANNEL,";
    private static final String LOGGED_IN = "LOGGED_IN";
    private static final String ENTITY_MEMBER = "ENTITY_MEMBER";
    private final Producer<String, String> _producer;
    private final ChannelMigrationDAO _migrationDao;
    private final MigratedItemDAO _migratedItemDao;
    private final NewsMigrationDAO _newsMigrationDao;
    private final UserGroupService _userGroupService;
    private final TransactionHelper _transactionHelper;
    private final PersonRolesMigrationService _personRolesMigrationService;
    private final TenantService _tenantService;

    @Autowired
    public ChannelMigrationService(@Nullable @Qualifier(value="KAFKA_LARGE_STRING_PRODUCER") Producer<String, String> producer, ChannelMigrationDAO migrationDao, MigratedItemDAO migratedItemDao, NewsMigrationDAO newsMigrationDao, UserGroupService userGroupService, TransactionHelper transactionHelper, PersonRolesMigrationService personRolesMigrationService, TenantService tenantService) {
        this._producer = producer;
        this._migrationDao = migrationDao;
        this._migratedItemDao = migratedItemDao;
        this._newsMigrationDao = newsMigrationDao;
        this._userGroupService = userGroupService;
        this._transactionHelper = transactionHelper;
        this._personRolesMigrationService = personRolesMigrationService;
        this._tenantService = tenantService;
    }

    public void migrateChannels() {
        LOG.info("Channel migration started");
        if (this._producer == null) {
            LOG.warn("Abort migrateChannels because _producer is null!");
            return;
        }
        ImmutableMap<EntityId, DBEntity> channelEntities = this._migrationDao.getAllChannels();
        ImmutableSet migratedChannels = this._migratedItemDao.getMigrationsByIds(channelEntities.keySet()).keySet();
        for (DBEntity channelEntity : channelEntities.values()) {
            this._transactionHelper.doInTransactionWithoutResult(arg_0 -> this.lambda$migrateChannels$0((Set)migratedChannels, channelEntity, arg_0));
        }
        this._personRolesMigrationService.exportPeopleToUserGroups();
        LOG.info("Channel migration finished");
    }

    private void migrateChannel(Set<EntityId> migratedChannels, DBEntity channelEntity) {
        if (migratedChannels.contains(channelEntity.getId())) {
            LOG.info("Skipping migration. Entity {} already migrated", (Object)channelEntity.getId());
            return;
        }
        String channelIdGenerated = CustomNanoId.randomNanoIdWithPrefix(CHANNEL);
        List<ChannelPermissionKafkaDto> permissions = this.getPermissions(channelEntity);
        List<ChannelSubscriptionKafkaDto> subscriptions = this.getSubscribers(channelEntity);
        this._migratedItemDao.insertMigrations(Map.of(channelEntity.getId(), new NewsChannelId(channelIdGenerated.split(CHANNEL)[1])));
        this.publishToKafka(new ChannelKafkaDto(channelIdGenerated, channelEntity.getId().asString(), channelEntity.getTenantId(), channelEntity.getName(), channelEntity.getCreateDate().toInstant(), channelEntity.getModifyDate().toInstant(), permissions, subscriptions));
        LOG.info("Channel {} ({}) successfully migrated", (Object)channelIdGenerated, (Object)channelEntity.getId().asString());
    }

    @Nonnull
    @VisibleForTesting
    protected List<ChannelPermissionKafkaDto> getPermissions(DBEntity channelEntity) {
        UserGroup allUsersGroup;
        boolean membersMayWrite;
        EntityId entityId = channelEntity.getId();
        ImmutableSet<PersonId> allChannelAdmins = this._migrationDao.getAllChannelAdmins(entityId);
        List<ChannelPermissionKafkaDto> permissions = this.convertPersonsToPermissionKafkaDto((Set<PersonId>)allChannelAdmins, MANAGER);
        ImmutableSetMultimap<DBPrivacyType, String> privacyTypeToPersonRole = this._personRolesMigrationService.getRolesForChannel(entityId);
        boolean loggedInMayRead = privacyTypeToPersonRole.get((Object)DBPrivacyType.VISIBILITY).contains((Object)LOGGED_IN);
        boolean loggedInMayWrite = privacyTypeToPersonRole.get((Object)DBPrivacyType.ENTITY_EDIT).contains((Object)LOGGED_IN);
        boolean membersMayRead = privacyTypeToPersonRole.get((Object)DBPrivacyType.VISIBILITY).contains((Object)ENTITY_MEMBER) || loggedInMayRead;
        boolean bl = membersMayWrite = membersMayRead && privacyTypeToPersonRole.get((Object)DBPrivacyType.ENTITY_EDIT).contains((Object)ENTITY_MEMBER) || loggedInMayWrite;
        if (loggedInMayWrite && loggedInMayRead) {
            allUsersGroup = this._userGroupService.getAllUsersGroup(channelEntity.getTenantId());
            if (allUsersGroup == null) {
                throw new NoSuchElementException("Missing allUsersGroup for tenantId: " + channelEntity.getTenantId());
            }
            ChannelPermissionKafkaDto allUserGroupWriter = new ChannelPermissionKafkaDto(allUsersGroup.getGroupId().toString(), WRITER);
            permissions.add(allUserGroupWriter);
        } else {
            if (loggedInMayRead) {
                allUsersGroup = this._userGroupService.getAllUsersGroup(channelEntity.getTenantId());
                if (allUsersGroup == null) {
                    throw new NoSuchElementException("Missing allUsersGroup for tenantId: " + channelEntity.getTenantId());
                }
                ChannelPermissionKafkaDto allUserGroupReader = new ChannelPermissionKafkaDto(allUsersGroup.getGroupId().toString(), READER);
                permissions.add(allUserGroupReader);
            }
            if (membersMayWrite) {
                permissions.addAll(this.addAllMembers(entityId, (Set<PersonId>)allChannelAdmins, WRITER));
            } else if (membersMayRead && !loggedInMayRead) {
                permissions.addAll(this.addAllMembers(entityId, (Set<PersonId>)allChannelAdmins, READER));
            }
        }
        Optional<TenantId> defaultTenant = this._tenantService.getOnlyTenant();
        if (defaultTenant.isPresent()) {
            permissions.addAll(this.addPersonRoles(channelEntity, loggedInMayRead, loggedInMayWrite));
        }
        return permissions;
    }

    @Nonnull
    private List<ChannelPermissionKafkaDto> addAllMembers(EntityId entityId, Set<PersonId> allChannelAdmins, String role) {
        ImmutableSet<PersonId> allChannelMembers = this._migrationDao.getAllChannelMembers(entityId);
        ArrayList<PersonId> allChannelMembersList = new ArrayList<PersonId>((Collection<PersonId>)allChannelMembers);
        allChannelMembersList.removeIf(allChannelAdmins::contains);
        return this.convertPersonsToPermissionKafkaDto(Set.copyOf(allChannelMembersList), role);
    }

    @Nonnull
    private List<ChannelPermissionKafkaDto> addPersonRoles(DBEntity channelEntity, boolean loggedInMayRead, boolean loggedInMayWrite) {
        ArrayList<ChannelPermissionKafkaDto> permissions = new ArrayList<ChannelPermissionKafkaDto>();
        EntityId entityId = channelEntity.getId();
        ImmutableSetMultimap<DBPrivacyType, String> privacyTypeToPersonRole = this._personRolesMigrationService.getPersonRolesForChannel(entityId);
        if (privacyTypeToPersonRole != null && !privacyTypeToPersonRole.isEmpty()) {
            ImmutableSet readerRoles = privacyTypeToPersonRole.get((Object)DBPrivacyType.VISIBILITY);
            ImmutableSet configuredWriterRoles = privacyTypeToPersonRole.get((Object)DBPrivacyType.ENTITY_EDIT);
            Stream writerRolesStream = loggedInMayWrite ? Stream.concat(configuredWriterRoles.stream(), readerRoles.stream()) : configuredWriterRoles.stream();
            Set<String> writerRoles = writerRolesStream.filter(arg_0 -> ChannelMigrationService.lambda$addPersonRoles$1(loggedInMayRead, (Set)readerRoles, arg_0)).collect(Collectors.toSet());
            if (!writerRoles.isEmpty()) {
                permissions.addAll(this.createUserGroupAndAddToPermissions(writerRoles, channelEntity.getTenantId(), WRITER));
            }
            Set<String> effectiveReaderRoles = readerRoles.stream().filter(r -> !writerRoles.contains(r)).collect(Collectors.toSet());
            if (!readerRoles.isEmpty()) {
                permissions.addAll(this.createUserGroupAndAddToPermissions(effectiveReaderRoles, channelEntity.getTenantId(), READER));
            }
        }
        return permissions;
    }

    private List<ChannelPermissionKafkaDto> createUserGroupAndAddToPermissions(Set<String> personRoles, TenantId tenantId, String newRole) {
        ArrayList<ChannelPermissionKafkaDto> permissions = new ArrayList<ChannelPermissionKafkaDto>();
        for (String personRole : personRoles) {
            UserGroupId userGroupId = this._personRolesMigrationService.getUserGroupForRole(tenantId, personRole);
            permissions.add(new ChannelPermissionKafkaDto(userGroupId.toString(), newRole));
        }
        return permissions;
    }

    @Nonnull
    private List<ChannelSubscriptionKafkaDto> getSubscribers(DBEntity channelEntity) {
        ImmutableList<SubscriptionModel> subscribers = this._newsMigrationDao.getSubscribers(Set.of(channelEntity.getId()));
        return subscribers.stream().map(subscriber -> {
            String id = "PERSONAL_SUBSCRIPTION," + UUID.randomUUID();
            return new ChannelSubscriptionKafkaDto(id, "PROFILE," + subscriber.getSubscriberId(), subscriber.getState() == SubscriptionState.SUBSCRIBED, subscriber.getState() == SubscriptionState.UNSUBSCRIBED);
        }).collect(Collectors.toList());
    }

    @Nonnull
    private List<ChannelPermissionKafkaDto> convertPersonsToPermissionKafkaDto(Set<PersonId> personIds, String role) {
        return personIds.stream().map(personId -> new ChannelPermissionKafkaDto("PROFILE," + personId.getId(), role)).collect(Collectors.toList());
    }

    private void publishToKafka(ChannelKafkaDto channelKafkaDto) {
        if (this._producer == null) {
            return;
        }
        String channelId = channelKafkaDto.getId();
        this._producer.send(new ProducerRecord("just.toro.migration.news", (Object)channelId, (Object)channelKafkaDto.toTopicJson()));
    }

    private static /* synthetic */ boolean lambda$addPersonRoles$1(boolean loggedInMayRead, Set readerRoles, String r) {
        if (loggedInMayRead) {
            return true;
        }
        return readerRoles.contains(r);
    }

    private /* synthetic */ void lambda$migrateChannels$0(Set migratedChannels, DBEntity channelEntity, TransactionStatus t) {
        this.migrateChannel(migratedChannels, channelEntity);
    }
}

