/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.integration.persistence.DriveDocumentItemDAO;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.news.migration.NewsMigrationDAO;
import de.justsoftware.onx.news.migration.channel.ChannelMigrationService;
import de.justsoftware.onx.news.migration.newscover.NewsCoverMigrationService;
import de.justsoftware.onx.news.migration.post.PostMigrationService;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SnowballMigrationService {
    public static final String MIGRATION_ITEM_TOPIC = "just.migration.item";
    public static final String NEWS_MIGRATION_TOPIC = "just.toro.migration.news";
    private static final String MIGRATION_END = "MIGRATION_END";
    private static final String POST = "POST,";
    private static final String CHANNEL = "CHANNEL,";
    private static final Logger LOG = LoggerFactory.getLogger(SnowballMigrationService.class);
    private final Producer<String, String> _producer;
    private final DriveDocumentItemDAO _documentDAO;
    private final MigratedItemDAO _migratedItemDAO;
    private final NewsMigrationDAO _newsMigrationDAO;
    private final ChannelMigrationService _channelMigrationService;
    private final PostMigrationService _postMigrationService;
    private final NewsCoverMigrationService _newsCoverMigrationService;

    @Autowired
    public SnowballMigrationService(@Nullable @Qualifier(value="KAFKA_LARGE_STRING_PRODUCER") Producer<String, String> producer, DriveDocumentItemDAO documentDAO, MigratedItemDAO migratedItemDAO, NewsMigrationDAO newsMigrationDAO, ChannelMigrationService channelMigrationService, PostMigrationService postMigrationService, NewsCoverMigrationService newsCoverMigrationService) {
        this._producer = producer;
        this._documentDAO = documentDAO;
        this._migratedItemDAO = migratedItemDAO;
        this._newsMigrationDAO = newsMigrationDAO;
        this._channelMigrationService = channelMigrationService;
        this._postMigrationService = postMigrationService;
        this._newsCoverMigrationService = newsCoverMigrationService;
    }

    public void startMigration() {
        this._channelMigrationService.migrateChannels();
        this._postMigrationService.migratePosts();
        this._newsCoverMigrationService.migrateNewsCovers();
        this.publishEndOfMigration();
    }

    public void resetMigration() {
        if (this._producer == null) {
            LOG.warn("Abort resetMigration because _producer is null!");
            return;
        }
        ImmutableMap<ItemId, ItemId> migratedChannels = this._newsMigrationDAO.getAllMigratedItems("CHANNEL,%");
        migratedChannels.forEach((entityId, channelId) -> {
            this._documentDAO.updateParentId((ItemId)channelId, (ItemId)entityId);
            this.publishToMigrationItemKafka(channelId.asString(), entityId.asString());
        });
        ImmutableMap<ItemId, ItemId> migratedPosts = this._newsMigrationDAO.getAllMigratedItems("POST,%");
        migratedPosts.forEach((workstreamMessageId, postId) -> {
            this._documentDAO.updateParentId((ItemId)postId, (ItemId)workstreamMessageId);
            this.publishToMigrationItemKafka(postId.asString(), workstreamMessageId.asString());
        });
        int deletedCount = this._migratedItemDAO.deleteAllChannelsAndPosts();
        LOG.info("Successfully deleted {} channels and posts from migrated_items", (Object)deletedCount);
    }

    private void publishToMigrationItemKafka(String postId, String workstreamMessageId) {
        if (this._producer == null) {
            return;
        }
        this._producer.send(new ProducerRecord(MIGRATION_ITEM_TOPIC, (Object)postId, (Object)workstreamMessageId));
    }

    public void publishEndOfMigration() {
        if (this._producer == null) {
            LOG.warn("Abort publishEndOfMigration because _producer is null!");
            return;
        }
        this._producer.send(new ProducerRecord(NEWS_MIGRATION_TOPIC, (Object)MIGRATION_END, null));
    }
}

