/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration;

import de.justsoftware.onx.ada.AdminInternalConnector;
import de.justsoftware.onx.news.NewsInternalApiConnector;
import de.justsoftware.onx.news.migration.SnowballMigrationService;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.person.business.PersonChangesPublisher;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class MigrateSnowballUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateSnowballUpdateProcessor.class);
    private final SnowballMigrationService _snowballMigrationService;
    private final PeopleInternalApiConnector _peopleInternalApiConnector;
    private final AdminInternalConnector _adminInternalConnector;
    private final PersonChangesPublisher _personChangesPublisher;
    private final NewsInternalApiConnector _newsInternalApiConnector;

    @Autowired
    public MigrateSnowballUpdateProcessor(SnowballMigrationService snowballMigrationService, PeopleInternalApiConnector peopleInternalApiConnector, AdminInternalConnector adminInternalConnector, PersonChangesPublisher personChangesPublisher, NewsInternalApiConnector newsInternalApiConnector) {
        this._snowballMigrationService = snowballMigrationService;
        this._peopleInternalApiConnector = peopleInternalApiConnector;
        this._adminInternalConnector = adminInternalConnector;
        this._personChangesPublisher = personChangesPublisher;
        this._newsInternalApiConnector = newsInternalApiConnector;
    }

    @Override
    @Nonnull
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.MIGRATE_NEWS;
    }

    @Override
    @Nonnull
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.20");
    }

    @Override
    public int getProcessorVersion() {
        return 0;
    }

    @Override
    public boolean preconditionsMet() {
        return this._peopleInternalApiConnector.hasSameJucoVersion() && this._newsInternalApiConnector.isAvailable();
    }

    @Override
    public void process() {
        LOG.info("Starting migrateSnowball");
        this._adminInternalConnector.republishAllTenants();
        this._personChangesPublisher.publishAllPersons();
        this._peopleInternalApiConnector.publishAllUserGroups();
        this._snowballMigrationService.startMigration();
        LOG.info("Finished migrateSnowball");
    }
}

