/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersion;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public final class MultiWikiVersion
implements IMultiWikiVersion,
Item<MultiWikiVersionId> {
    public static final Function<IMultiWikiVersion, MultiWikiVersion> COPY = new NullPermeableFunction<IMultiWikiVersion, MultiWikiVersion>(){

        @Override
        protected MultiWikiVersion applySafe(IMultiWikiVersion input) {
            return new MultiWikiVersion(input);
        }
    };
    public static final Function<IMultiWikiVersion, MultiWikiId> GET_PARENT_ID = new NullPermeableFunction<IMultiWikiVersion, MultiWikiId>(){

        @Override
        protected MultiWikiId applySafe(IMultiWikiVersion input) {
            return input.getParentId();
        }
    };
    private final MultiWikiVersionId _id;
    private final MultiWikiId _parentId;

    public MultiWikiVersion(@Nonnull IMultiWikiVersion multiWikiVersion) {
        this._id = multiWikiVersion.getId();
        this._parentId = multiWikiVersion.getParentId();
    }

    @Override
    public MultiWikiVersionId getId() {
        return this._id;
    }

    @Override
    @Nonnull
    public MultiWikiId getParentId() {
        return this._parentId;
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.MULTI_WIKI;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).toString();
    }
}

