/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWiki;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public final class MultiWiki
implements IMultiWiki,
Item<MultiWikiId> {
    public static final Function<IMultiWiki, MultiWiki> COPY = new NullPermeableFunction<IMultiWiki, MultiWiki>(){

        @Override
        protected MultiWiki applySafe(IMultiWiki input) {
            return new MultiWiki(input);
        }
    };
    private final MultiWikiId _id;
    private final EntityId _parentId;

    public MultiWiki(@Nonnull IMultiWiki multiWiki) {
        this._id = multiWiki.getId();
        this._parentId = multiWiki.getParentId();
    }

    @Override
    public MultiWikiId getId() {
        return this._id;
    }

    @Override
    @Nonnull
    public EntityId getParentId() {
        return this._parentId;
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.MULTI_WIKI;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).toString();
    }
}

