/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.BatchStatementProcessor;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.multiwiki.integration.persistence.MultiWikiDAO;
import de.justsoftware.onx.multiwiki.integration.persistence.ibatis.DBMultiWikiVersionSection;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersionSection;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class IbatisMultiWikiDAO
implements MultiWikiDAO {
    private static final String NAMESPACE = "MultiWiki.";
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisMultiWikiDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("MultiWiki");
    }

    @Override
    public ImmutableMap<MultiWikiId, MultiWiki> getWikisByIds(Set<MultiWikiId> ids) {
        ImmutableMap result = IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MultiWiki.getMultiWikisByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return ImmutableMap.copyOf((Map)Maps.transformValues(result, MultiWiki.COPY));
    }

    @Override
    public ImmutableMap<MultiWikiVersionId, MultiWikiVersion> getWikiVersionsByIds(Set<MultiWikiVersionId> ids) {
        ImmutableMap result = IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MultiWiki.getWikiVersionsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return ImmutableMap.copyOf((Map)Maps.transformValues(result, MultiWikiVersion.COPY));
    }

    @Override
    public ImmutableMap<MultiWikiVersionSectionId, MultiWikiVersionSection> getWikiSectionsByIds(Set<MultiWikiVersionSectionId> ids) {
        ImmutableMap dbResult = IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MultiWiki.getWikiVersionSectionsByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        final ImmutableSetMultimap<MultiWikiVersionSectionId, String> roleMap = this.getRolesAllowedToReadByIds(ids);
        return ImmutableMap.copyOf((Map)Maps.transformValues(dbResult, (Function)new NullPermeableFunction<DBMultiWikiVersionSection, MultiWikiVersionSection>(){

            @Override
            protected MultiWikiVersionSection applySafe(DBMultiWikiVersionSection input) {
                return new MultiWikiVersionSection(input, (ImmutableSet<String>)roleMap.get((Object)input.getId()));
            }
        }));
    }

    @Override
    public MultiWikiVersionSection getWikiSection(MultiWikiVersionId versionId, MultiWikiSectionId sectionId) {
        DBMultiWikiVersionSection dbResult = (DBMultiWikiVersionSection)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "MultiWiki.getWikiVersionSectionByVersion", ImmutableMap.of((Object)"versionId", (Object)versionId, (Object)"sectionId", (Object)sectionId));
        if (dbResult == null) {
            return null;
        }
        return new MultiWikiVersionSection(dbResult, (ImmutableSet<String>)this.getRolesAllowedToReadByIds((Set<MultiWikiVersionSectionId>)ImmutableSet.of((Object)dbResult.getId())).get((Object)dbResult.getId()));
    }

    @Override
    public MultiWikiId insertWiki(EntityId parentId) {
        Long newId = (Long)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "MultiWiki.nextWikiId");
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "MultiWiki.insertWiki", ImmutableMap.of((Object)"id", (Object)newId, (Object)"parentId", (Object)parentId));
        return new MultiWikiId(newId);
    }

    @Override
    public MultiWikiVersionId insertVersion(MultiWikiId wikiId) {
        Long newId = (Long)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "MultiWiki.nextVersionId");
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "MultiWiki.insertVersion", ImmutableMap.of((Object)"id", (Object)newId, (Object)"wikiId", (Object)wikiId));
        return new MultiWikiVersionId(newId);
    }

    @Override
    public MultiWikiVersionSectionId insertVersionSection(final MultiWikiVersionId versionId, final MultiWikiSectionId sectionId, final String headline, final String text, final int order, final Iterable<String> rolesAllowedToRead) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<MultiWikiVersionSectionId>(){

            public MultiWikiVersionSectionId doInTransaction(TransactionStatus status) {
                Long newId = (Long)IbatisDAOUtil.wrappedQueryForObject(IbatisMultiWikiDAO.this._sqlMapper, "MultiWiki.nextVersionSectionId");
                Long newSectionId = sectionId == null ? (Long)IbatisDAOUtil.wrappedQueryForObject(IbatisMultiWikiDAO.this._sqlMapper, "MultiWiki.nextSectionId") : Long.valueOf(sectionId.getId());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"id", (Object)newId);
                builder.put((Object)"versionId", (Object)versionId);
                builder.put((Object)"sectionId", (Object)newSectionId);
                builder.put((Object)"headLine", (Object)headline);
                builder.put((Object)"html", (Object)text);
                builder.put((Object)"order", (Object)order);
                IbatisDAOUtil.wrappedInsert(IbatisMultiWikiDAO.this._sqlMapper, "MultiWiki.insertVersionSection", builder.build());
                MultiWikiVersionSectionId result = new MultiWikiVersionSectionId(newId);
                IbatisMultiWikiDAO.this.insertRolesAllowedToRead(rolesAllowedToRead, result);
                return result;
            }
        });
    }

    @Override
    public ImmutableMap<EntityId, MultiWikiId> getWikisByParentIds(Set<EntityId> parentIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MultiWiki.getWikisByParentIds", "key", "value", parentIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableMap<MultiWikiId, MultiWikiVersionId> getNewestVersions(Set<MultiWikiId> multiWikiIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapper, "MultiWiki.getNewestVersions", "key", "value", multiWikiIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableListMultimap<MultiWikiVersionId, MultiWikiVersionSection> getSectionsInVersions(Set<MultiWikiVersionId> versions) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        ImmutableList sectionsFromDb = IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "MultiWiki.getSectionsInVersions", versions, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        ImmutableSet sectionIds = ImmutableSet.copyOf((Iterable)Iterables.transform(sectionsFromDb, IMultiWikiVersionSection.GET_VERSION_SECTION_ID));
        ImmutableSetMultimap<MultiWikiVersionSectionId, String> roleMap = this.getRolesAllowedToReadByIds((Set<MultiWikiVersionSectionId>)sectionIds);
        for (DBMultiWikiVersionSection dbSection : sectionsFromDb) {
            result.put((Object)dbSection.getParentId(), (Object)new MultiWikiVersionSection(dbSection, (ImmutableSet<String>)roleMap.get((Object)dbSection.getId())));
        }
        return result.build();
    }

    @Nonnull
    private ImmutableSetMultimap<MultiWikiVersionSectionId, String> getRolesAllowedToReadByIds(@Nonnull Set<MultiWikiVersionSectionId> versionIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForSetMultimap(this._sqlMapper, "MultiWiki.getWikiVersionSectionRolesAllowedToReadByIds", "key", "value", versionIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void deleteVersions(Set<MultiWikiVersionId> versionIdsToDelete) {
        this._statementBuilder.delete("deleteVersions").partition(versionIdsToDelete);
    }

    @Override
    public void deleteVersionSections(Set<MultiWikiVersionId> versionIdsToDelete) {
        this._statementBuilder.delete("deleteVersionSections").partition(versionIdsToDelete);
    }

    private void insertRolesAllowedToRead(@Nullable Iterable<String> roleNames, final @Nonnull MultiWikiVersionSectionId versionSectionId) {
        if (CollectionUtil.isEmpty(roleNames)) {
            return;
        }
        IbatisDAOUtil.executeInBatch(this._sqlMapper, Lists.newArrayList(roleNames), 1000, new BatchStatementProcessor<String>(){

            @Override
            public void process(SqlMapClient client, String roleName) throws SQLException {
                client.insert("MultiWiki.insertRolesAllowedToRead", (Object)ImmutableMap.of((Object)"versionSectionId", (Object)versionSectionId, (Object)"roleName", (Object)roleName));
            }
        });
    }
}

