/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.integration.persistence.EntityVersionComponentsDao;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.multiwiki.business.MultiWikiVersionDeletionHandler;
import de.justsoftware.onx.multiwiki.business.MultiWikiWriteDataService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiWikiVersionDeletionHandlerImpl
implements MultiWikiVersionDeletionHandler {
    @Autowired
    private MultiWikiWriteDataService _multiWikiWriteDataService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;
    @Autowired
    private EntityVersionComponentsDao _entityVersionComponentsDao;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet.Builder versionBuilder = ImmutableSet.builder();
        ImmutableSet entityVersionIds = ImmutableSet.copyOf((Iterable)Iterables.filter(parentIds, EntityVersionId.class));
        this.handleDeletedEntityVersions((Set<EntityVersionId>)entityVersionIds, deletionContext, (ImmutableSet.Builder<MultiWikiVersionId>)versionBuilder);
        ImmutableSet versionsToDelete = versionBuilder.build();
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)versionsToDelete, deletionContext);
        this._multiWikiWriteDataService.deleteMultiWikiVersions((Set<MultiWikiVersionId>)versionsToDelete);
    }

    private void handleDeletedEntityVersions(@Nonnull Set<EntityVersionId> entityVersionIds, @Nonnull DeletionContext deletionContext, @Nonnull ImmutableSet.Builder<MultiWikiVersionId> versionBuilder) {
        ImmutableMap<EntityVersionId, MultiWikiVersionId> multiWikiVersionIds = this._entityVersionService.getMultiWikiVersionsForEntityVersions(entityVersionIds);
        ImmutableMap notYetDeletedVersions = ImmutableMap.copyOf((Map)Maps.filterValues(multiWikiVersionIds, deletionContext.notYetDeletedPredicate()));
        deletionContext.addDeletedItems((Iterable<? extends ItemId>)notYetDeletedVersions.values());
        versionBuilder.addAll((Iterable)notYetDeletedVersions.values());
        this._entityVersionComponentsDao.deleteVersionComponents((Set<EntityVersionId>)notYetDeletedVersions.keySet());
    }
}

