/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.multiwiki.business.MultiWikiReadDataService;
import de.justsoftware.onx.multiwiki.business.MultiWikiWriteDataService;
import de.justsoftware.onx.multiwiki.integration.persistence.MultiWikiDAO;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWiki;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersion;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiWikiReadWriteDataServiceImpl
implements MultiWikiReadDataService,
MultiWikiWriteDataService {
    private final MultiWikiDAO _multiWikiDAO;

    @Autowired
    @ParametersAreNonnullByDefault
    public MultiWikiReadWriteDataServiceImpl(MultiWikiDAO multiWikiDAO) {
        this._multiWikiDAO = multiWikiDAO;
    }

    @Override
    public MultiWikiVersionId insertVersion(MultiWikiId wikiId) {
        return this._multiWikiDAO.insertVersion(wikiId);
    }

    @Override
    public MultiWikiVersionSectionId insertVersionSection(MultiWikiVersionId versionId, MultiWikiSectionId sectionId, String headline, String text, int order, Iterable<String> rolesAllowedToRead) {
        return this._multiWikiDAO.insertVersionSection(versionId, sectionId, headline, text, order, rolesAllowedToRead);
    }

    @Override
    public MultiWikiId insertWiki(EntityId parentGlobalId) {
        return this._multiWikiDAO.insertWiki(parentGlobalId);
    }

    @Override
    public ImmutableMap<MultiWikiId, MultiWiki> getWikisByIds(Set<MultiWikiId> ids) {
        return this._multiWikiDAO.getWikisByIds(ids);
    }

    @Override
    public ImmutableMap<MultiWikiVersionSectionId, MultiWikiVersionSection> getWikiSectionsByIds(Set<MultiWikiVersionSectionId> ids) {
        return this._multiWikiDAO.getWikiSectionsByIds(ids);
    }

    @Override
    public MultiWikiVersionSection getWikiSection(MultiWikiVersionId versionId, MultiWikiSectionId sectionId) throws InvalidIDException {
        return InvalidIDException.check(versionId, this._multiWikiDAO.getWikiSection(versionId, sectionId));
    }

    @Override
    public ImmutableMap<MultiWikiVersionId, MultiWikiVersion> getWikiVersionsByIds(Set<MultiWikiVersionId> ids) {
        return this._multiWikiDAO.getWikiVersionsByIds(ids);
    }

    @Override
    public ImmutableMap<EntityId, MultiWikiId> getWikisByParentIds(Set<EntityId> parentIds) {
        return this._multiWikiDAO.getWikisByParentIds(parentIds);
    }

    @Override
    public ImmutableMap<MultiWikiId, MultiWikiVersionId> getNewestVersions(Set<MultiWikiId> multiWikiIds) {
        return this._multiWikiDAO.getNewestVersions(multiWikiIds);
    }

    @Override
    public MultiWikiVersionId getNewestVersion(MultiWikiId wikiId) throws InvalidIDException {
        return InvalidIDException.check(wikiId, (MultiWikiVersionId)this.getNewestVersions((Set<MultiWikiId>)ImmutableSet.of((Object)wikiId)).get((Object)wikiId));
    }

    @Override
    public ImmutableList<MultiWikiVersionSection> getSectionsInVersion(MultiWikiVersionId versionId) {
        return this.getSectionsInVersions((Set<MultiWikiVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId);
    }

    @Override
    public ImmutableListMultimap<MultiWikiVersionId, MultiWikiVersionSection> getSectionsInVersions(Set<MultiWikiVersionId> versions) {
        return this._multiWikiDAO.getSectionsInVersions(versions);
    }

    @Override
    public void deleteMultiWikiVersions(Set<MultiWikiVersionId> versionIds) {
        this._multiWikiDAO.deleteVersionSections(versionIds);
        this._multiWikiDAO.deleteVersions(versionIds);
    }
}

