/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.multiwiki.business.MultiWikiDeletionHandler;
import de.justsoftware.onx.multiwiki.business.MultiWikiReadDataService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiWikiDeletionHandlerImpl
implements MultiWikiDeletionHandler {
    @Autowired
    private MultiWikiReadDataService _multiWikiReadDataService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet entityIds = ImmutableSet.copyOf((Iterable)Iterables.filter(parentIds, EntityId.class));
        if (CollectionUtil.isEmpty(entityIds)) {
            return;
        }
        ImmutableSet multiWikiIdsToDelete = deletionContext.filterItemsNotYetDeleted(this._multiWikiReadDataService.getWikisByParentIds((Set<EntityId>)entityIds).values());
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)multiWikiIdsToDelete, deletionContext);
    }
}

