/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business.model;

import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum QueueName {
    SEARCH_INDEX("search-index"),
    UPDATE_EVENT("update-event"),
    ITEM_VISIBILITY("item-visibility");

    private static final HashMap<String, QueueName> PATH_NAME_MAP;
    private final String _pathName;

    private QueueName(String pathName) {
        this._pathName = pathName;
    }

    @Nonnull
    public String getPathName() {
        return this._pathName;
    }

    @CheckForNull
    public static QueueName byPathName(String pathName) {
        return PATH_NAME_MAP.get(pathName);
    }

    static {
        PATH_NAME_MAP = new HashMap();
        for (QueueName value : QueueName.values()) {
            PATH_NAME_MAP.put(value.getPathName(), value);
        }
    }
}

