/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mobile.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.Id;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.mobile.model.ResolvedDesktopHistoryTokenType;
import de.justsoftware.onx.tasks.shared.model.TaskFilterId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ResolvedDesktopHistoryToken {
    public static final ResolvedDesktopHistoryToken STARTPAGE = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.STARTPAGE);
    public static final ResolvedDesktopHistoryToken HOME = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.HOME);
    public static final ResolvedDesktopHistoryToken NOTIFICATION_CENTER = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NOTIFICATION_CENTER);
    public static final ResolvedDesktopHistoryToken NOT_SUPPORTED = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NOT_SUPPORTED);
    public static final ResolvedDesktopHistoryToken INVALID = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.INVALID);
    public static final ResolvedDesktopHistoryToken ALL_ENTITIES = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.ALL_ENTITIES);
    public static final ResolvedDesktopHistoryToken FEED = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FEED);
    public static final ResolvedDesktopHistoryToken CHANNELS = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.CHANNELS);
    public static final ResolvedDesktopHistoryToken WIKI = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.WIKI);
    public static final ResolvedDesktopHistoryToken SHARES = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.SHARES);
    public static final ResolvedDesktopHistoryToken NEWS_FEED = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NEWS_FEED);
    public static final ResolvedDesktopHistoryToken NEWS_CHANNELS = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NEWS_CHANNELS);
    public static final ResolvedDesktopHistoryToken PEOPLE_GROUPS = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.PEOPLE_GROUPS);
    public static final ResolvedDesktopHistoryToken PEOPLE_USERS = new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.PEOPLE_USERS);
    private final ResolvedDesktopHistoryTokenType _type;
    private final Id _resourceId;

    public ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType type, @Nullable Id resourceId) {
        this._type = type;
        this._resourceId = resourceId;
    }

    private ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType type) {
        this(type, null);
    }

    @Nonnull
    public ResolvedDesktopHistoryTokenType getType() {
        return this._type;
    }

    @CheckForNull
    public Id getResourceId() {
        return this._resourceId;
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("resourceId", (Object)this._resourceId);
    }

    @ParametersAreNonnullByDefault
    public static class TaskListToken
    extends ResolvedDesktopHistoryToken {
        private final TaskFilterId _filterId;

        public TaskListToken(TaskFilterId filterId) {
            super(ResolvedDesktopHistoryTokenType.TASK_LIST);
            this._filterId = filterId;
        }

        @Nonnull
        public TaskFilterId getFilterId() {
            return this._filterId;
        }

        @Override
        public String toString() {
            return this.toStringHelper().add("filterId", (Object)this._filterId).toString();
        }
    }

    @ParametersAreNonnullByDefault
    public static class AnchorToken
    extends ResolvedDesktopHistoryToken {
        private final String _anchor;
        private final ImmutableSet<String> _anchorEntityComponents;

        public AnchorToken(EntityId entityId, @Nullable String anchor, @Nullable ImmutableSet<String> anchorEntityComponents) {
            super(ResolvedDesktopHistoryTokenType.RESOURCE, entityId);
            this._anchor = anchor;
            this._anchorEntityComponents = anchorEntityComponents;
        }

        @CheckForNull
        public String getAnchor() {
            return this._anchor;
        }

        @CheckForNull
        public ImmutableSet<String> getAnchorEntityComponents() {
            return this._anchorEntityComponents;
        }

        @Override
        public String toString() {
            return this.toStringHelper().add("anchor", (Object)this._anchor).add("anchorEntityComponents", this._anchorEntityComponents).toString();
        }
    }
}

