/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mobile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.shared.model.Id;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.Functions;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.business.EntityAnchorService;
import de.justsoftware.onx.container.shared.model.EntityAnchorComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.mobile.model.ResolvedDesktopHistoryToken;
import de.justsoftware.onx.mobile.model.ResolvedDesktopHistoryTokenType;
import de.justsoftware.onx.tasks.shared.model.StaticTaskFilterIds;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class DesktopHistoryTokenResolverService {
    private static final Pattern DRIVE_URL = Pattern.compile("^#?/drive/(file|folder)/([0-9A-Fa-f-]*)");
    private static final Pattern DRIVE_SHARES_URL = Pattern.compile("^#?/drive/shares");
    private static final Pattern DRIVE_PREVIEW_URL = Pattern.compile(".*\\?previewDocumentId=([0-9A-Fa-f-]*).*");
    private static final Pattern ENTITY_FOLDER_URL = Pattern.compile("/folder/([0-9A-Fa-f-]*)");
    private static final Pattern HOMESCREEN_URL = Pattern.compile("^#?/homescreen\\?*(.*)");
    private static final Pattern LEGACY_NEWS_URL = Pattern.compile("^#?/archivednews/(feed|channel|posts)/?(.+)?");
    private static final Pattern NEWS_URL = Pattern.compile("^#?/news/(feed|channel|posts)/?(.+)?/.*");
    private static final Pattern TASKS_URL = Pattern.compile("^#?/tasks/filter/([^/]+)/?(.+)?");
    private static final Pattern WIKI_URL = Pattern.compile("^#?/wiki/?(wikis|chapters|articles)?/?(.+)?");
    private static final Pattern PEOPLE_URL = Pattern.compile("^#?/people/(profile|groups|users)/?(.*)?");
    private static final Pattern CHAT_URL = Pattern.compile("^#?/chat/?(.*)?");
    private final EntityAnchorService _entityAnchorService;
    private final ServerUrlUtil _serverUrlUtil;

    @Autowired
    public DesktopHistoryTokenResolverService(EntityAnchorService entityAnchorService, ServerUrlUtil serverUrlUtil) {
        this._entityAnchorService = entityAnchorService;
        this._serverUrlUtil = serverUrlUtil;
    }

    @Nonnull
    public ResolvedDesktopHistoryToken resolveToken(@Nullable String desktopHistoryToken, AuthorizationCheckContext authContext) {
        if (desktopHistoryToken == null) {
            return ResolvedDesktopHistoryToken.INVALID;
        }
        Function resolver = Functions.findFirstNonNull(this::resolveDrivePreviewToken, this::resolveHomescreenToken, this::resolveDriveToken, this::resolveLegacyNewsToken, this::resolveNewsToken, this::resolveTasksToken, this::resolveWikiToken, this::resolvePeopleToken, this::resolveChatToken, t -> this.resolveHistoryToken((String)t, authContext));
        ResolvedDesktopHistoryToken resolvedToken = (ResolvedDesktopHistoryToken)resolver.apply(desktopHistoryToken);
        return resolvedToken == null ? ResolvedDesktopHistoryToken.INVALID : resolvedToken;
    }

    @Nonnull
    public ResolvedDesktopHistoryToken resolveTokenFromUrl(@Nullable String url, AuthorizationCheckContext authContext) {
        return this.resolveToken(this.getDesktopHistoryToken(url), authContext);
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveHistoryToken(String token, AuthorizationCheckContext authContext) {
        try {
            HistoryTokenParser parsed = TokenUtilServer.INSTANCE.parse(token);
            HistoryToken historyToken = parsed.getToken();
            if (historyToken == null) {
                return null;
            }
            return historyToken.accept(new ResolveHistoryTokenVisitor(parsed, authContext));
        }
        catch (TokenUtil.TokenParseException e) {
            return null;
        }
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveDrivePreviewToken(String token) {
        Matcher previewUrlMatcher = DRIVE_PREVIEW_URL.matcher(token);
        if (previewUrlMatcher.matches()) {
            return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FILE, new DriveDocumentId(previewUrlMatcher.group(1)));
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveDriveToken(String token) {
        Matcher driveUrlMatcher = DRIVE_URL.matcher(token);
        Matcher sharesUrlMatcher = DRIVE_SHARES_URL.matcher(token);
        if (driveUrlMatcher.matches()) {
            switch (driveUrlMatcher.group(1)) {
                case "folder": {
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FOLDER, new DriveDocumentId(driveUrlMatcher.group(2)));
                }
            }
            return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FILE, new DriveDocumentId(driveUrlMatcher.group(2)));
        }
        if (sharesUrlMatcher.matches()) {
            return ResolvedDesktopHistoryToken.SHARES;
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveLegacyNewsToken(String token) {
        Matcher legacyNewsMatcher = LEGACY_NEWS_URL.matcher(token);
        if (legacyNewsMatcher.matches()) {
            switch (legacyNewsMatcher.group(1)) {
                case "feed": {
                    return ResolvedDesktopHistoryToken.FEED;
                }
                case "channel": {
                    ItemId itemId = ItemId.parse(legacyNewsMatcher.group(2));
                    if (itemId == null) {
                        return ResolvedDesktopHistoryToken.CHANNELS;
                    }
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.CHANNEL, itemId);
                }
                case "posts": {
                    WorkstreamMessageId postId = WorkstreamMessageId.parse(legacyNewsMatcher.group(2));
                    if (postId == null) {
                        return ResolvedDesktopHistoryToken.INVALID;
                    }
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.RESOURCE, postId);
                }
            }
            return ResolvedDesktopHistoryToken.INVALID;
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveNewsToken(String token) {
        Matcher newsMatcher = NEWS_URL.matcher(token);
        if (newsMatcher.matches()) {
            switch (newsMatcher.group(1)) {
                case "feed": {
                    return ResolvedDesktopHistoryToken.NEWS_FEED;
                }
                case "channel": {
                    String untypedNewsChannelId = newsMatcher.group(2);
                    if (untypedNewsChannelId == null) {
                        return ResolvedDesktopHistoryToken.NEWS_CHANNELS;
                    }
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NEWS_CHANNEL, new NewsChannelId(untypedNewsChannelId));
                }
                case "posts": {
                    String untypedPostId = newsMatcher.group(2);
                    if (untypedPostId == null) {
                        return ResolvedDesktopHistoryToken.INVALID;
                    }
                    if (token.endsWith("#comments")) {
                        return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NEWS_COMMENTS, new NewsPostId(untypedPostId));
                    }
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.NEWS_POST, new NewsPostId(untypedPostId));
                }
            }
            return ResolvedDesktopHistoryToken.INVALID;
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveWikiToken(String token) {
        Matcher wikiMatcher = WIKI_URL.matcher(token);
        if (wikiMatcher.matches()) {
            if (wikiMatcher.group(1) == null) {
                return ResolvedDesktopHistoryToken.WIKI;
            }
            ItemId itemId = ItemId.parse(wikiMatcher.group(2));
            return itemId == null ? ResolvedDesktopHistoryToken.WIKI : new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.RESOURCE, itemId);
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolvePeopleToken(String token) {
        Matcher peopleMatcher = PEOPLE_URL.matcher(token);
        if (peopleMatcher.matches()) {
            switch (peopleMatcher.group(1)) {
                case "profile": {
                    Long id = GlobalId.parseId(peopleMatcher.group(2));
                    return id != null ? new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.RESOURCE, new ProfileId(id)) : null;
                }
                case "groups": {
                    Optional<UserGroupId> userGroupId = UserGroupId.parse(peopleMatcher.group(2));
                    return userGroupId.map(groupId -> new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.PEOPLE_GROUP, (Id)groupId)).orElse(ResolvedDesktopHistoryToken.PEOPLE_GROUPS);
                }
                case "users": {
                    return ResolvedDesktopHistoryToken.PEOPLE_USERS;
                }
            }
            return ResolvedDesktopHistoryToken.INVALID;
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveChatToken(String token) {
        Matcher chatMatcher = CHAT_URL.matcher(token);
        if (chatMatcher.matches()) {
            try {
                String chatIdCandidate = chatMatcher.group(1);
                ChatId chatId = ChatId.parseNonnull(chatIdCandidate);
                return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.CHAT, chatId);
            }
            catch (IdParseException e) {
                return ResolvedDesktopHistoryToken.INVALID;
            }
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveTasksToken(String token) {
        Matcher tasksMatcher = TASKS_URL.matcher(token);
        if (tasksMatcher.matches()) {
            String filter = tasksMatcher.group(1);
            ItemId taskId = ItemId.parse(tasksMatcher.group(2));
            if (taskId instanceof TaskId) {
                return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.TASK, taskId);
            }
            if (taskId != null) {
                return ResolvedDesktopHistoryToken.INVALID;
            }
            switch (filter) {
                case "assignedToMe": {
                    return new ResolvedDesktopHistoryToken.TaskListToken(StaticTaskFilterIds.ASSIGNED_TO_ME);
                }
                case "createdByMe": {
                    return new ResolvedDesktopHistoryToken.TaskListToken(StaticTaskFilterIds.CREATED_BY_ME);
                }
            }
            ItemId taskListId = ItemId.parse(filter);
            return taskListId instanceof TaskListId ? new ResolvedDesktopHistoryToken.TaskListToken(new TaskListFilterId((TaskListId)taskListId)) : ResolvedDesktopHistoryToken.INVALID;
        }
        return null;
    }

    @CheckForNull
    private ResolvedDesktopHistoryToken resolveHomescreenToken(String token) {
        Matcher homescreenUrlMatcher = HOMESCREEN_URL.matcher(token);
        if (homescreenUrlMatcher.matches()) {
            if ("notification".equals(homescreenUrlMatcher.group(1))) {
                return ResolvedDesktopHistoryToken.NOTIFICATION_CENTER;
            }
            return ResolvedDesktopHistoryToken.HOME;
        }
        return null;
    }

    @CheckForNull
    private static String entityAnchorComponentString(EntityAnchorComponent component) {
        switch (component) {
            case DESCRIPTION: {
                return StaticEntityTab.INFORMATION.getName();
            }
            case MULTI_WIKI: {
                return StaticComponentType.MULTI_WIKI.getName();
            }
            case RAW_EDITOR1: {
                return StaticComponentType.RAW_EDITOR1.getName();
            }
            case RAW_EDITOR2: {
                return StaticComponentType.RAW_EDITOR2.getName();
            }
            case RAW_EDITOR3: {
                return StaticComponentType.RAW_EDITOR3.getName();
            }
            case RAW_EDITOR4: {
                return StaticComponentType.RAW_EDITOR4.getName();
            }
            case WIKI_EDITOR: {
                return StaticComponentType.WIKI_EDITOR.getName();
            }
        }
        return null;
    }

    @Nullable
    private String getDesktopHistoryToken(@Nullable String url) {
        boolean isDesktopLink;
        if (url == null) {
            return null;
        }
        if (this.isDesktopHistoryToken(url)) {
            return url;
        }
        URI parsedUrl = this.parseUri(url);
        if (parsedUrl == null) {
            return null;
        }
        if (!this.isSameHost(parsedUrl)) {
            return null;
        }
        String path = parsedUrl.getPath();
        boolean bl = isDesktopLink = path != null && !path.isBlank() && path.startsWith("/toro/resource/html");
        if (!isDesktopLink) {
            return null;
        }
        String fragment = parsedUrl.getFragment();
        if (fragment == null) {
            return null;
        }
        String token = "#" + fragment;
        return this.isDesktopHistoryToken(token) ? token : null;
    }

    private boolean isSameHost(URI uri) {
        return !uri.isAbsolute() || uri.toString().startsWith(this._serverUrlUtil.getSystemDomainPrefix());
    }

    @Nullable
    private URI parseUri(@Nonnull String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private boolean isDesktopHistoryToken(@Nonnull String token) {
        return token.startsWith("#!") || token.startsWith("#/");
    }

    @ParametersAreNonnullByDefault
    private class ResolveHistoryTokenVisitor
    implements HistoryToken.Visitor<ResolvedDesktopHistoryToken> {
        private final HistoryTokenParser _parsedToken;
        private final AuthorizationCheckContext _authContext;

        ResolveHistoryTokenVisitor(HistoryTokenParser parsedToken, AuthorizationCheckContext authContext) {
            this._parsedToken = parsedToken;
            this._authContext = authContext;
        }

        @Nonnull
        private ResolvedDesktopHistoryToken resolveToGlobalId(ItemType itemType) {
            List<HistoryTokenParser.TokenParam> tokenParams = this._parsedToken.getParams();
            if (tokenParams.size() < 1) {
                return ResolvedDesktopHistoryToken.INVALID;
            }
            try {
                Long id = tokenParams.get(0).asLong();
                if (id == null) {
                    return ResolvedDesktopHistoryToken.INVALID;
                }
                GlobalId itemId = GlobalId.create(id, itemType);
                if (!(itemId instanceof EntityId)) {
                    return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.RESOURCE, itemId);
                }
                return this.createResolvedTokenForGlobalId((EntityId)itemId);
            }
            catch (NumberFormatException e) {
                return ResolvedDesktopHistoryToken.INVALID;
            }
        }

        @Nonnull
        private ResolvedDesktopHistoryToken createResolvedTokenForGlobalId(EntityId entityId) {
            Matcher m;
            List<HistoryTokenParser.TokenParam> params = this._parsedToken.getParams();
            if (params.size() > 2 && StaticEntityTab.DOCUMENTS.name().equals(params.get(1).asString()) && (m = ENTITY_FOLDER_URL.matcher(((HistoryTokenParser.TokenParam)Iterables.getLast(params)).asString())).matches()) {
                return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FOLDER, new DriveDocumentId(m.group(1)));
            }
            String hash = this._parsedToken.getHash();
            if (hash == null) {
                return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.RESOURCE, entityId);
            }
            ImmutableSet<EntityAnchorComponent> components = DesktopHistoryTokenResolverService.this._entityAnchorService.getComponentsForHash(entityId, hash, this._authContext);
            ImmutableSet componentNames = (ImmutableSet)components.stream().map(x$0 -> DesktopHistoryTokenResolverService.entityAnchorComponentString(x$0)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            return new ResolvedDesktopHistoryToken.AnchorToken(entityId, hash, (ImmutableSet<String>)componentNames);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitWorkstreamItem(HistoryToken ht) {
            return this.resolveToGlobalId(ItemType.WORKSTREAM_MESSAGE);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitEntity(HistoryToken ht) {
            return this.resolveToGlobalId(ItemType.ENTITY);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitAllEntities(HistoryToken historyToken) {
            return ResolvedDesktopHistoryToken.ALL_ENTITIES;
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitProfile(HistoryToken ht) {
            return this.resolveToGlobalId(ItemType.PROFILE);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitStart(HistoryToken ht) {
            return ResolvedDesktopHistoryToken.STARTPAGE;
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitHome(HistoryToken historyToken) {
            return ResolvedDesktopHistoryToken.HOME;
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMdlDocument(HistoryToken ht) {
            return this.resolveToGlobalId(ItemType.DOCUMENT);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMdlImage(HistoryToken ht) {
            return this.resolveToGlobalId(ItemType.ALBUM_IMAGE);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMdlVideoLink(HistoryToken historyToken) {
            return this.resolveToGlobalId(ItemType.VIDEOLINK);
        }

        @Nonnull
        private ResolvedDesktopHistoryToken visitDefault(HistoryToken ht) {
            return ResolvedDesktopHistoryToken.NOT_SUPPORTED;
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitSettings(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMyDraftEntities(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitWikiEditorVersions(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitEntityVersionCompare(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitSurvey(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitConfigSurvey(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitSearchText(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitFriends(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitInfo(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitConfigEntity(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMdlVideos(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitMdlAlbum(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitAlbums(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitModifyDefaultEntityDesign(HistoryToken historyToken) {
            return this.visitDefault(historyToken);
        }

        @Override
        @Nonnull
        public ResolvedDesktopHistoryToken visitDrivePreview(HistoryToken historyToken) {
            List<HistoryTokenParser.TokenParam> tokenParams = this._parsedToken.getParams();
            if (tokenParams.size() < 1) {
                return ResolvedDesktopHistoryToken.INVALID;
            }
            String id = tokenParams.get(0).asString();
            return new ResolvedDesktopHistoryToken(ResolvedDesktopHistoryTokenType.FILE, new DriveDocumentId(id));
        }
    }
}

