/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.studienstiftung.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.integration.persistence.LanguageDAO;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityMemberWorkflowImportService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.PersonUpdateEvent;
import de.justsoftware.onx.events.UpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.impl.PersonImportServiceImpl;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.PersonImportDAO;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.studienstiftung.business.StudienstiftungImportService;
import de.justsoftware.onx.migration.studienstiftung.business.StudienstiftungPersonImportDataProvider;
import de.justsoftware.onx.person.business.PersonExternalIdPublisher;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonWriteDataService;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.profile.business.ProfileReadDataService;
import de.justsoftware.onx.profile.business.ProfileWriteDataService;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.security.service.MobileLogoutService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParametersAreNonnullByDefault
public class StudienstiftungImportServiceImpl
extends PersonImportServiceImpl<DatabasePersonImportModel>
implements StudienstiftungImportService {
    private final PersonImportMappingDAO _personImportMappingDAO;
    private final PersonImportDAO _personImportDAO;
    private final EntityMemberWorkflowImportService _memberWorkflowImportService;
    private final LikeWriteDataService _likeWriteService;
    private StudienstiftungPersonImportDataProvider<DatabasePersonImportModel> _dataProvider;

    @Autowired
    public StudienstiftungImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, PersonDAO personDAO, LanguageDAO languageDAO, PersonWriteDataService personWriteDataService, PersonImportMappingDAO personImportMappingDAO, Settings settings, ProfileReadDataService profileReadDataService, ProfileWriteDataService profileWriteDataService, TransactionHelper transactionHelper, PersonImportDAO personImportDAO, EntityMemberWorkflowImportService memberWorkflowImportService, LikeWriteDataService likeWriteService, PersonExternalIdPublisher personExternalIdPublisher, MobileLogoutService mobileLogoutService, JucoPasswordEncoder passwordEncoder, @Qualifier(value="importTenantIdSupplier") Supplier<TenantId> tenantIdSupplier, PersonTenantService personTenantService, ImportProcessLockService importProcessLockService) {
        super(personService, updateEventHandler, eventBus, clock, importResultMailService, personDAO, languageDAO, personWriteDataService, personImportMappingDAO, settings, profileReadDataService, profileWriteDataService, transactionHelper, personExternalIdPublisher, mobileLogoutService, passwordEncoder, tenantIdSupplier, personTenantService, importProcessLockService);
        this._personImportMappingDAO = personImportMappingDAO;
        this._personImportDAO = personImportDAO;
        this._memberWorkflowImportService = memberWorkflowImportService;
        this._likeWriteService = likeWriteService;
    }

    @Override
    public void setImportDataProvider(PersonImportServiceImpl.PersonImportDataProvider<DatabasePersonImportModel> dataProvider) {
        if (!(dataProvider instanceof StudienstiftungPersonImportDataProvider)) {
            throw new IllegalArgumentException("Got wrong type of DataProvider. StudienstiftungPersonImportDataProvider is required.");
        }
        super.setImportDataProvider(dataProvider);
        this._dataProvider = (StudienstiftungPersonImportDataProvider)dataProvider;
    }

    @Override
    protected Iterable<List<DatabasePersonImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        Iterable importModels = Iterables.concat(this._dataProvider.getImportModels(statistics));
        Iterable externalIds = StreamSupport.stream(importModels.spliterator(), false).map(DatabasePersonImportModel.TO_EXTERNAL_ID).filter(Objects::nonNull).collect(Collectors.toList());
        IMPORT_LOG.info("Found " + Iterables.size((Iterable)importModels) + " users in datasource.");
        Map<String, PersonId> internalIds = this._personImportMappingDAO.getInternalIds(externalIds);
        List importModelsForUpdate = StreamSupport.stream(importModels.spliterator(), false).filter(m -> m != null && internalIds.get(m.getExternalId()) != null).collect(Collectors.toList());
        int difference = Iterables.size((Iterable)importModels) - importModelsForUpdate.size();
        statistics.incSkipped(difference);
        IMPORT_LOG.info("Skipping " + difference + " users because they do not yet have an account.");
        IMPORT_LOG.info("Updating " + importModelsForUpdate.size() + " users.");
        return ImmutableList.of(importModelsForUpdate);
    }

    @Override
    public DatabasePersonImportModel getAndMapPersonImportModel(String email) throws ImportException {
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        DatabasePersonImportModel importModelByMail = this._dataProvider.getImportModelByMail(email, statistics);
        if (importModelByMail == null) {
            return null;
        }
        Set<String> importedFieldNames = this._dataProvider.getImportedFieldNames();
        Set<String> preProcessedFieldNames = importModelByMail.getPreProcessedFieldNames();
        ImmutableSet fieldNames = ImmutableSet.copyOf((Iterable)Iterables.concat(importedFieldNames, preProcessedFieldNames));
        this.setImportedValues(importModelByMail, (Set<String>)fieldNames);
        return importModelByMail;
    }

    @Override
    public DatabasePersonImportModel importPerson(String email, ImportUpdateEventCollector eventCollector) throws ImportException {
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        DatabasePersonImportModel importModelByMail = this._dataProvider.getImportModelByMail(email, statistics);
        if (importModelByMail == null) {
            return null;
        }
        this._personImportMappingDAO.removeIdMapping((String)importModelByMail.getExternalId());
        return this.processImportModel(importModelByMail, statistics, eventCollector);
    }

    @Override
    public void importMembershipsAndSubscriptionsByExternalId(String externalId, PersonId internalId, Set<EntityId> defaultEntityIds, ImportUpdateEventCollector eventCollector) {
        Set<EntityId> importedMemberships = this.importMemberships(externalId, internalId, defaultEntityIds, eventCollector);
        Set<EntityId> importedSubscriptions = this.importSubscriptions(externalId, internalId, defaultEntityIds);
        eventCollector.addUpdateEvents((Iterable<? extends UpdateEvent<?>>)ImmutableSet.of((Object)new PersonUpdateEvent(internalId.asProfileId())));
        eventCollector.addUpdateEvents(Stream.concat(importedMemberships.stream(), importedSubscriptions.stream()).map(EntityUpdateEvent::new).collect(Collectors.toSet()));
    }

    @Nonnull
    private Set<EntityId> importMemberships(String externalId, PersonId internalId, Set<EntityId> defaultEntityIds, ImportUpdateEventCollector eventCollector) {
        MemberChangeOptions noNotifications = MemberChangeOptions.builder().disableEmailNotification().setBulk(true).setEntityNewMembershipWorkstreamMessage(false).setUpdateSubscriptions(false).build();
        List<EntityId> membershipsByExternalId = this._personImportDAO.getMembershipsByExternalId(externalId);
        Set<EntityId> membershipIds = Stream.concat(defaultEntityIds.stream(), membershipsByExternalId.stream()).collect(Collectors.toSet());
        for (EntityId entityId : membershipIds) {
            this._memberWorkflowImportService.addMembers(entityId, (Set<PersonId>)ImmutableSet.of((Object)internalId), noNotifications, eventCollector);
        }
        return membershipIds;
    }

    @Nonnull
    private Set<EntityId> importSubscriptions(String externalId, PersonId internalId, Set<EntityId> defaultEntityIds) {
        List<EntityId> subscriptionsByExternalId = this._personImportDAO.getSubscriptionsByExternalId(externalId);
        Map<EntityId, PersonId> subscriptions = Stream.concat(defaultEntityIds.stream(), subscriptionsByExternalId.stream()).collect(Collectors.toMap(sId -> sId, sId -> internalId));
        this._likeWriteService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.copyOf(subscriptions.entrySet()), SubscriptionState.SUBSCRIBED, SubscriptionType.DEFAULT, true);
        return subscriptions.keySet();
    }
}

