/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.auditing.shared.AuditSensitive;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.shared.server.model.ImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class PersonImportModel<T>
implements ImportModel {
    public static final Function<PersonImportModel<?>, PersonId> TO_PERSON_ID = input -> input != null ? input.getPerson().getId() : null;
    private static final Predicate<PersonImportModel<?>> ACTIVE_PERSONS = input -> input != null && input.getPerson().isActive();
    private final ArrayListMultimap<String, Object> _importedValues = ArrayListMultimap.create();
    private final Set<String> _preProcessedFieldNames = Sets.newHashSet();
    private final Map<String, Properties> _fieldParameter = new HashMap<String, Properties>();
    private final T _externalId;
    private List<UserGroupId> _addedUserGroupMemberships = List.of();
    private List<UserGroupId> _removedUserGroupMemberships = List.of();
    private final Map<String, ProfileAttributeBlock> _attributeBlocksBySectionName = new HashMap<String, ProfileAttributeBlock>();
    private DBPerson _person;
    @AuditSensitive
    private String _plainPassword;
    private boolean _new;
    private Boolean _active = null;
    private Boolean _blocked = null;

    public PersonImportModel(DBPerson person, T externalId) {
        this._person = person;
        this._externalId = externalId;
    }

    @Nonnull
    public static <I> Set<I> toExternalIdsOfActiveUsers(List<? extends PersonImportModel<I>> importedPersons) {
        return importedPersons.stream().filter(ACTIVE_PERSONS).map(PersonImportModel::getExternalId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void setPerson(DBPerson person) {
        this._person = person;
    }

    @Nonnull
    public ListMultimap<String, Object> getImportedValues() {
        return this._importedValues;
    }

    public void addFieldParameters(String juCoFieldName, Properties properties) {
        this._fieldParameter.put(juCoFieldName, properties);
    }

    @CheckForNull
    public String getFieldParameter(String juCoFieldName, String parameterName) {
        Properties parameters = this._fieldParameter.get(juCoFieldName);
        return parameters == null ? null : parameters.getProperty(parameterName);
    }

    @Nonnull
    public DBPerson getPerson() {
        return this._person;
    }

    @Nonnull
    public Map<String, ProfileAttributeBlock> getProfileAttributeBlocks() {
        return this._attributeBlocksBySectionName;
    }

    public void addProfileAttributeBlock(String sectionName, ProfileAttributeBlock block) {
        this._attributeBlocksBySectionName.put(sectionName, block);
    }

    public boolean isNew() {
        return this._new;
    }

    public void setNew(boolean isNewUser) {
        this._new = isNewUser;
    }

    @CheckForNull
    public String getPlainPassword() {
        return this._plainPassword;
    }

    public void setPlainPassword(String plainPassword) {
        this._plainPassword = plainPassword;
    }

    @Nonnull
    public T getExternalId() {
        return this._externalId;
    }

    @CheckForNull
    public T getFallbackExternalId() {
        return null;
    }

    @CheckForNull
    public abstract <R> R accept(PersonImportModelVisitor<R> var1);

    @CheckForNull
    public String getImportedEmail() {
        return (String)Iterables.getFirst((Iterable)this._importedValues.get((Object)"person.email"), null);
    }

    public void addPreProcessedFieldName(String fieldName) {
        this._preProcessedFieldNames.add(fieldName);
    }

    @Nonnull
    public Set<String> getPreProcessedFieldNames() {
        return this._preProcessedFieldNames;
    }

    @Nonnull
    public static <I> Function<PersonImportModel<I>, I> toExternalId() {
        return input -> input != null ? input.getExternalId() : null;
    }

    public void setActive(boolean active) {
        this._active = active;
        this._person.setActive(active);
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
        this._person.setBlocked(blocked);
    }

    @CheckForNull
    public Boolean isActive() {
        return this._active;
    }

    @CheckForNull
    public Boolean isBlocked() {
        return this._blocked;
    }

    @Nonnull
    public List<UserGroupId> getAddedUserGroupMemberships() {
        return this._addedUserGroupMemberships;
    }

    public void setAddedUserGroupMemberships(List<UserGroupId> userGroupMemberships) {
        this._addedUserGroupMemberships = userGroupMemberships;
    }

    @Nonnull
    public List<UserGroupId> getRemovedUserGroupMemberships() {
        return this._removedUserGroupMemberships;
    }

    public void setRemovedUserGroupMemberships(List<UserGroupId> userGroupMemberships) {
        this._removedUserGroupMemberships = userGroupMemberships;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("person", (Object)this._person).add("importedValues", this._importedValues).add("preProcessedFieldNames", this._preProcessedFieldNames).add("fieldParameter", this._fieldParameter.size()).add("externalId", this._externalId).add("plainPassword", (Object)"********").add("new", this._new).add("addedUserGroupMemberships", this._addedUserGroupMemberships.size()).add("removedUserGroupMemberships", this._removedUserGroupMemberships.size()).toString();
    }
}

