/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.Nonnull;
import javax.naming.Name;
import javax.naming.directory.Attributes;

public class LDAPPersonImportModel
extends PersonImportModel<String> {
    private final Attributes _attributes;
    private final Name _dn;
    private final String _externalIdWithoutDomain;

    public LDAPPersonImportModel(@Nonnull DBPerson person, @Nonnull String externalIdField, @Nonnull String externalId, @Nonnull Attributes attributes, @Nonnull Name dn, @Nonnull DomainResolver.Domain domain) {
        super(person, LDAPPersonIdentifier.fromName(externalIdField, externalId, domain).toExternalIdString());
        this._externalIdWithoutDomain = externalId;
        this._attributes = attributes;
        this._dn = dn;
    }

    @Nonnull
    public Attributes getAttributes() {
        return this._attributes;
    }

    @Nonnull
    public Name getDN() {
        return this._dn;
    }

    @Nonnull
    public String getExternalIdWithoutDomain() {
        return this._externalIdWithoutDomain;
    }

    @Override
    public String getFallbackExternalId() {
        return this.getExternalIdWithoutDomain();
    }

    @Override
    public <R> R accept(PersonImportModelVisitor<R> v) {
        return v.visitLDAPPersonImportModel(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", (Object)this._attributes).add("dn", (Object)this._dn).toString();
    }
}

