/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.shared.server.model.EntityImportBean;
import de.justsoftware.onx.migration.shared.server.model.ImportModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityImportModel<T>
implements ImportModel {
    public static final Function<EntityImportModel<?>, EntityId> TO_ENTITY_ID = new Function<EntityImportModel<?>, EntityId>(){

        public EntityId apply(EntityImportModel<?> input) {
            return input != null ? input.getEntity().getEntityId() : null;
        }
    };
    private final EntityImportBean<T> _entity;
    private final PersonId _adminId;

    public EntityImportModel() {
        this(new EntityImportBean(), null);
    }

    public EntityImportModel(@Nonnull EntityImportBean<T> entityBean, @Nullable PersonId adminId) {
        this._entity = entityBean;
        this._adminId = adminId;
    }

    @Nonnull
    public EntityImportBean<T> getEntity() {
        return this._entity;
    }

    @CheckForNull
    public T getExternalId() {
        return this._entity.getExternalId();
    }

    @CheckForNull
    public PersonId getAdminId() {
        return this._adminId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", this._entity).toString();
    }
}

