/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.integration.persistence.PersonImportDAO;
import de.justsoftware.onx.migration.integration.persistence.ibatis.PersonEntityMappingIbatisModel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class IbatisPersonImportDAO
implements PersonImportDAO {
    private static final String NAMESPACE = "PersonImport";
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisPersonImportDAO(@Qualifier(value="sqlMapClientImport") SqlMapClient sqlMapClient, @Value(value="${JDBC.DBType}") String jdbcDBType) {
        this._statementBuilder = new IbatisStatementBuilder(sqlMapClient, NAMESPACE, jdbcDBType);
    }

    @Override
    public List<Map<String, Object>> getImportModels() {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getImportModels").noParam()).asList();
    }

    @Override
    public Map<String, Object> getImportModelByMail(String email) {
        ImmutableList results = ((IbatisStandardResultBuilder)this._statementBuilder.select("getImportModelByMail").param("email", email)).asList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            PersonImportService.IMPORT_LOG.warn("Retrieved multiple import results with the same email address, retrieving last hit: " + email);
            return (Map)Iterables.getLast(results);
        }
        return (Map)Iterables.getOnlyElement(results);
    }

    @Override
    public List<EntityId> getMembershipsByExternalId(String externalId) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getMembershipsByExternalId").param("externalId", externalId)).asList();
    }

    @Override
    public List<EntityId> getSubscriptionsByExternalId(String externalId) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("getSubscriptionsByExternalId").param("externalId", externalId)).asList();
    }

    @Override
    public List<PersonEntityMappingIbatisModel> getMembershipsByExternalIds(Set<String> externalIds) {
        return externalIds.isEmpty() ? ImmutableList.of() : ((IbatisPartitionResultBuilder)this._statementBuilder.select("getMembershipsByExternalIds").partition(externalIds)).asList();
    }

    @Override
    public List<PersonEntityMappingIbatisModel> getSubscriptionsByExternalIds(Set<String> externalIds) {
        return externalIds.isEmpty() ? ImmutableList.of() : ((IbatisPartitionResultBuilder)this._statementBuilder.select("getSubscriptionsByExternalIds").partition(externalIds)).asList();
    }
}

