/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class IbatisLongIdEntityImportDAO
implements EntityImportDAO<Long> {
    protected String _namespace = "EntityImport.";
    protected SqlMapClient _sqlMapper;

    public void setNamespace(@Nonnull String namespace) {
        this._namespace = namespace + ".";
    }

    @Required
    public void setSqlMapper(@Nonnull SqlMapClient sqlMapper) {
        this._sqlMapper = sqlMapper;
    }

    @Override
    public void insertIdMapping(EntityId entityId, Long externalId) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, this._namespace + "insertExternalAndInternalId", ImmutableMap.of((Object)"internalId", (Object)entityId, (Object)"externalId", (Object)externalId));
    }

    @Override
    public EntityId getInternalId(Long externalId) {
        return (EntityId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, this._namespace + "getInternalIdByExternalId", externalId);
    }

    @Override
    public Map<Long, EntityId> getInternalIds(Collection<Long> externalIds) {
        return IbatisDAOUtil.wrappedQueryForMap(this._sqlMapper, this._namespace + "getInternalIdByExternalIds", ImmutableMap.of((Object)"externalIds", IbatisDAOUtil.toIbatisList(externalIds)), "key", "value");
    }

    @Override
    public Long getExternalId(EntityId internalId) {
        return (Long)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, this._namespace + "getExternalIdByInternalId", internalId);
    }
}

