/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.image.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.integration.persistence.AlbumDAO;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.common.business.StorageServerConfig;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.migration.drive.DriveDocumentMigrationService;
import de.justsoftware.onx.migration.drive.MigratedDocument;
import de.justsoftware.onx.migration.drive.MigratedVersion;
import de.justsoftware.onx.migration.image.WorkstreamImageMigrationService;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class WorkstreamImageMigrationServiceImpl
implements WorkstreamImageMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(WorkstreamImageMigrationServiceImpl.class);
    private static final int CHUNK_SIZE = 100;
    private static final String ORIGINAL_IMAGE_PATH = "images/original/mdlalbum/";
    private final RestOperations _restTemplate;
    private final WorkstreamDAO _workstreamDAO;
    private final AlbumDAO _albumDAO;
    private final DriveDocumentMigrationService _driveDocumentMigrationService;
    private final MigratedItemDAO _migratedItemDAO;
    private final StorageServerConfig _storageServerConfig;

    @Autowired
    public WorkstreamImageMigrationServiceImpl(@Qualifier(value="defaultRestTemplate") RestOperations restTemplate, WorkstreamDAO workstreamDAO, AlbumDAO albumDAO, DriveDocumentMigrationService driveDocumentMigrationService, MigratedItemDAO migratedItemDAO, StorageServerConfig storageServerConfig) {
        this._restTemplate = restTemplate;
        this._workstreamDAO = workstreamDAO;
        this._albumDAO = albumDAO;
        this._driveDocumentMigrationService = driveDocumentMigrationService;
        this._migratedItemDAO = migratedItemDAO;
        this._storageServerConfig = storageServerConfig;
    }

    @Override
    public void migrate() {
        StopWatch stopWatch = new StopWatch("workstream-image-migration");
        LOG.info("starting export of workstream images");
        stopWatch.start("export");
        AtomicInteger counter = new AtomicInteger(0);
        int total = this._workstreamDAO.forAllWorkstreamImages(100, chunk -> counter.addAndGet(this.handleChunk((Map<AlbumImageId, WorkstreamMessageId>)chunk)));
        LOG.info("exported workstream images:" + counter + "/" + total);
        stopWatch.stop();
        stopWatch.start("migrating activity messages");
        int migratedMessages = this._migratedItemDAO.deleteActivityMessagesOfTypes(WorkstreamMessageType.ALBUM_IMAGE_CREATED, WorkstreamMessageType.ALBUM_IMAGE_COMMENTED);
        LOG.info("deleted " + migratedMessages + " activity messages");
        stopWatch.stop();
        this._driveDocumentMigrationService.migrateDriveDocuments(stopWatch);
    }

    private int handleChunk(Map<AlbumImageId, WorkstreamMessageId> chunk) {
        ImmutableMap<AlbumImageId, DBAlbumImage> images = this._albumDAO.getImagesByIds(chunk.keySet());
        ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> workstreamMessages = this._workstreamDAO.getEntries((Set<WorkstreamMessageId>)ImmutableSet.copyOf(chunk.values()));
        ImmutableMap.Builder migratedIdBuilder = ImmutableMap.builder();
        EntryStream.from(chunk).mapKey(arg_0 -> images.get(arg_0)).mapValue(arg_0 -> workstreamMessages.get(arg_0)).filterKey(Objects::nonNull).filterValue(Objects::nonNull).forEach((image, workstreamMessage) -> this.migrate((DBAlbumImage)image, (DBWorkstreamMessage)workstreamMessage, (arg_0, arg_1) -> ((ImmutableMap.Builder)migratedIdBuilder).put(arg_0, arg_1)));
        ImmutableMap migratedIds = migratedIdBuilder.build();
        this._migratedItemDAO.insertMigrations((Map<? extends ItemId, ? extends ItemId>)migratedIds);
        this._albumDAO.deleteImages((Set<AlbumImageId>)migratedIds.keySet());
        return migratedIds.size();
    }

    @Nonnull
    private Optional<HttpHeaders> getImageHeader(DBAlbumImage image) {
        try {
            return Optional.ofNullable(this._restTemplate.headForHeaders(this._storageServerConfig.getUrlWithPath(WorkstreamImageMigrationServiceImpl.getImagePath(image)), new Object[0]));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    private void migrate(DBAlbumImage image, DBWorkstreamMessage workstreamMessage, BiConsumer<AlbumImageId, DriveDocumentId> migratedIds) {
        this.getImageHeader(image).ifPresent(headers -> {
            MediaType contentType = headers.getContentType();
            long fileSize = headers.getContentLength();
            if (fileSize >= 0L && contentType != null) {
                DriveDocumentId documentId = DriveDocumentId.random();
                this.publishVersionToKafka(image, workstreamMessage, contentType, fileSize, documentId);
                this.publishDocumentToKafka(image, workstreamMessage, documentId);
                migratedIds.accept(image.getId(), documentId);
            }
        });
    }

    private void publishDocumentToKafka(DBAlbumImage image, DBWorkstreamMessage workstreamMessage, DriveDocumentId documentId) {
        this._driveDocumentMigrationService.publishMigratedObject(new MigratedDocument(image.getId().asString() + "#document", documentId, "", WorkstreamImageMigrationServiceImpl.getTitle(image), workstreamMessage.getOriginItemId(), workstreamMessage.getId()));
    }

    private static String getTitle(DBAlbumImage image) {
        return Strings.nullToEmpty((String)image.getTitle()).trim();
    }

    private void publishVersionToKafka(DBAlbumImage image, DBWorkstreamMessage workstreamMessage, MediaType contentType, long fileSize, DriveDocumentId documentId) {
        String mimeType = contentType.getType() + "/" + contentType.getSubtype();
        this._driveDocumentMigrationService.publishMigratedObject(new MigratedVersion(image.getId().asString() + "#version", documentId, UUID.randomUUID(), this.generateFilename(image, contentType), workstreamMessage.getOriginItemId(), 1, WorkstreamImageMigrationServiceImpl.getImagePath(image), image.getCreateDate(), image.getOwnerId(), mimeType, fileSize, null, null, workstreamMessage.getId()));
    }

    private String generateFilename(DBAlbumImage image, MediaType contentType) {
        String title = WorkstreamImageMigrationServiceImpl.getTitle(image);
        String storageHash = image.getFilename();
        int startOfExtension = storageHash.lastIndexOf(46);
        String extension = startOfExtension >= 0 ? storageHash.substring(startOfExtension + 1) : contentType.getSubtype();
        String fileName = title.isEmpty() ? String.valueOf(image.getId().getId()) : title;
        return fileName + "." + extension.toLowerCase(Locale.ENGLISH);
    }

    @Nonnull
    @VisibleForTesting
    static String getImagePath(DBAlbumImage image) {
        return ORIGINAL_IMAGE_PATH + image.getFilename();
    }

    @Override
    public boolean isReady() {
        return this._driveDocumentMigrationService.isReady();
    }
}

