/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.drive;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.migration.drive.MigratedObject;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Date;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class MigratedVersion
implements MigratedObject {
    private final String _driveDocumentId;
    private final String _driveVersionId;
    private final String _originId;
    private final String _parentId;
    private final String _workstreamMessageId;
    private final int _version;
    private final String _fileName;
    private final String _storageServerPath;
    private final String _uploadedAt;
    private final long _owner;
    private final String _mimeType;
    private final long _fileSize;
    @CheckForNull
    private final String _restoredFrom;
    private final String _previewId;

    public MigratedVersion(String originId, ItemId driveDocumentId, UUID driveVersionId, String fileName, ItemId parentId, int version, String storageServerPath, Date uploadedAt, PersonId owner, String mimeType, long fileSize, @Nullable UUID restoredFrom, @Nullable String previewId, @Nullable WorkstreamMessageId workstreamMessageId) {
        this._originId = originId;
        this._driveDocumentId = driveDocumentId.asString();
        this._driveVersionId = driveVersionId.toString();
        this._fileName = fileName;
        this._parentId = parentId.asString();
        this._version = version;
        this._storageServerPath = storageServerPath;
        this._uploadedAt = new DateTime((Object)uploadedAt).toString();
        this._owner = owner.getId();
        this._mimeType = mimeType;
        this._fileSize = fileSize;
        this._restoredFrom = restoredFrom != null ? restoredFrom.toString() : null;
        this._previewId = previewId;
        this._workstreamMessageId = workstreamMessageId != null ? workstreamMessageId.asString() : null;
    }

    @Nonnull
    public String getDriveDocumentId() {
        return this._driveDocumentId;
    }

    @Nonnull
    public String getDriveVersionId() {
        return this._driveVersionId;
    }

    @Override
    public String getOriginId() {
        return this._originId;
    }

    @Nonnull
    public String getParentId() {
        return this._parentId;
    }

    public int getVersion() {
        return this._version;
    }

    @Nonnull
    public String getStorageServerPath() {
        return this._storageServerPath;
    }

    @Nonnull
    public String getUploadedAt() {
        return this._uploadedAt;
    }

    @Nonnull
    public String getMimeType() {
        return this._mimeType;
    }

    public long getOwner() {
        return this._owner;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    @CheckForNull
    public String getRestoredFrom() {
        return this._restoredFrom;
    }

    @Nonnull
    public String getFileName() {
        return this._fileName;
    }

    @CheckForNull
    public String getPreviewId() {
        return this._previewId;
    }

    @CheckForNull
    public String getWorkstreamMessageId() {
        return this._workstreamMessageId;
    }
}

