/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.conversation;

import de.justsoftware.onx.drive.integration.persistence.ibatis.IbatisDriveDocumentItemDAO;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.migration.conversation.MigratedConversationIdProducer;
import de.justsoftware.onx.migration.conversation.persistence.MigratedConversationIdDAO;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class MigratedConversationIdUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    public static final int BATCH_SIZE = 1000;
    private final MigratedConversationIdDAO _migrationDao;
    private final IbatisDriveDocumentItemDAO _driveDocumentItemDao;
    private final MigratedConversationIdProducer _producer;

    @Autowired
    public MigratedConversationIdUpdateProcessor(MigratedConversationIdDAO migratedConversationIdDao, IbatisDriveDocumentItemDAO driveDocumentItemDao, MigratedConversationIdProducer migratedConversationIdProducer) {
        this._migrationDao = migratedConversationIdDao;
        this._driveDocumentItemDao = driveDocumentItemDao;
        this._producer = migratedConversationIdProducer;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.MIGRATE_CONVERSATION_ID;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.1");
    }

    @Override
    public boolean preconditionsMet() {
        return true;
    }

    @Override
    public int getProcessorVersion() {
        return 1;
    }

    @Override
    public void process() {
        HashMap<String, ConversationId> conversationIdMap = new HashMap<String, ConversationId>();
        this._migrationDao.forAll((originalId, migratedId) -> {
            this._producer.send((String)originalId, (ConversationId)migratedId);
            conversationIdMap.put((String)originalId, (ConversationId)migratedId);
            if (conversationIdMap.size() > 1000) {
                this._driveDocumentItemDao.migrateToNewConversationId(conversationIdMap);
                conversationIdMap.clear();
            }
        });
        this._driveDocumentItemDao.migrateToNewConversationId(conversationIdMap);
    }
}

