/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.model;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import de.justsoftware.onx.migration.shared.model.ImportResult;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@ParametersAreNonnullByDefault
public class ImportStatistics {
    private static final String UNIDENTIFIED = "unidentified";
    private final DateTime _startTime;
    private final AtomicInteger _processedCount = new AtomicInteger();
    private final AtomicInteger _insertCount = new AtomicInteger();
    private final AtomicInteger _updateCount = new AtomicInteger();
    private final AtomicInteger _failedCount = new AtomicInteger();
    private final AtomicInteger _skippedCount = new AtomicInteger();
    private final AtomicInteger _successfulImports = new AtomicInteger();
    private final AtomicInteger _failedImports = new AtomicInteger();
    private final AtomicInteger _skippedImports = new AtomicInteger();
    private final ImmutableListMultimap.Builder<ImportErrorType, String> _errors = ImmutableListMultimap.builder();
    private DateTime _endTime;

    public ImportStatistics(DateTime startTime) {
        this._startTime = startTime;
    }

    public ImportStatistics(DateTime startTime, DateTime endTime) {
        this._startTime = startTime;
        this._endTime = endTime;
    }

    private ImportStatistics(DateTime startTime, @Nullable DateTime endTime, int processed, int inserted, int updated, int failed, int skipped, ImmutableListMultimap<ImportErrorType, String> errors, int successfulImports, int failedImports, int skippedImports) {
        this._startTime = startTime;
        this._endTime = endTime;
        this._processedCount.set(processed);
        this._insertCount.set(inserted);
        this._updateCount.set(updated);
        this._failedCount.set(failed);
        this._skippedCount.set(skipped);
        this._errors.putAll(errors);
        this._successfulImports.set(successfulImports);
        this._failedImports.set(failedImports);
        this._skippedImports.set(skippedImports);
    }

    public void incProcessed(int delta) {
        this._processedCount.addAndGet(delta);
    }

    public void incInserted() {
        this._insertCount.incrementAndGet();
    }

    public void incInserted(int delta) {
        this._insertCount.addAndGet(delta);
    }

    public void incUpdated() {
        this._updateCount.incrementAndGet();
    }

    public void incUpdated(int delta) {
        this._updateCount.addAndGet(delta);
    }

    public void incFailed(ImportErrorType type, @Nullable String identifier) {
        this.incFailed();
        this._errors.put((Object)type, (Object)(identifier == null ? UNIDENTIFIED : identifier));
    }

    public void incFailed() {
        this._failedCount.incrementAndGet();
    }

    public void incSkipped() {
        this._skippedCount.incrementAndGet();
    }

    public void incSkipped(int delta) {
        this._skippedCount.addAndGet(delta);
    }

    public void incSkipped(ImportErrorType type, @Nullable String identifier) {
        this.incSkipped();
        this._errors.put((Object)type, (Object)(identifier == null ? UNIDENTIFIED : identifier));
    }

    public void incSuccessfulImports() {
        this._successfulImports.incrementAndGet();
    }

    public void incSuccessfulImports(int successful) {
        this._successfulImports.addAndGet(successful);
    }

    public void incFailedImports() {
        this._failedImports.incrementAndGet();
    }

    public void incFailedImports(int delta) {
        this._failedImports.addAndGet(delta);
    }

    public void incSkippedImports() {
        this._skippedImports.incrementAndGet();
    }

    @Nonnull
    public DateTime getStartTime() {
        return this._startTime;
    }

    public int getProcessedCount() {
        return this._processedCount.get();
    }

    public int getInsertCount() {
        return this._insertCount.get();
    }

    public int getUpdateCount() {
        return this._updateCount.get();
    }

    public int getFailedCount() {
        return this._failedCount.get();
    }

    public int getSkippedCount() {
        return this._skippedCount.get();
    }

    @Nonnull
    public ImmutableListMultimap<ImportErrorType, String> getErrors() {
        return this._errors.build();
    }

    public int getSuccessfulImports() {
        return this._successfulImports.get();
    }

    public int getFailedImports() {
        return this._failedImports.get();
    }

    public int getSkippedImports() {
        return this._skippedImports.get();
    }

    public void setEndTime(@Nullable DateTime endTime) {
        this._endTime = endTime;
    }

    @CheckForNull
    public DateTime getEndTime() {
        return this._endTime;
    }

    @Nonnull
    public String getStatMessageAtEndTime(DateTime endTime) {
        this._endTime = endTime;
        return this.getStatMessage();
    }

    @Nonnull
    public String getStatMessage() {
        StringBuffer message = new StringBuffer();
        message.append("* Finished import");
        if (this._endTime != null) {
            message.append(" at " + this._endTime.toString() + " (within " + (this._endTime.getMillis() - this.getStartTime().getMillis()) + " milliseconds).");
        }
        message.append(System.lineSeparator()).append(this.getSuccessfulImports()).append(" successful and ").append(this.getSkippedImports()).append(" skipped and ").append(this.getFailedImports()).append(" failed imports.").append(System.lineSeparator()).append("===> Summary: ").append(this.getProcessedCount()).append(" entries processed ( ").append(this.getInsertCount()).append(" inserted | ").append(this.getUpdateCount()).append(" updated | ").append(this.getSkippedCount()).append(" skipped | ").append(this.getFailedCount()).append(" failed )");
        return message.toString();
    }

    @Nonnull
    public ImportResult toImportResult() {
        return new ImportResult(this.getProcessedCount(), this.getInsertCount(), this.getUpdateCount(), this.getFailedCount(), this.getSkippedCount(), new DateWithoutTimezone(this.getStartTime().toDate()), this._endTime == null ? null : new DateWithoutTimezone(this._endTime.toDate()), this.getSuccessfulImports(), this.getFailedImports());
    }

    @Nonnull
    private DateTime mergeEndTime(DateTime otherEndTime) {
        return this._endTime == null ? otherEndTime : (this._endTime.isAfter((ReadableInstant)otherEndTime) ? this._endTime : otherEndTime);
    }

    @Nonnull
    public ImportStatistics merge(@Nullable ImportStatistics otherStatistics) {
        if (otherStatistics == null) {
            return this;
        }
        DateTime otherStartTime = otherStatistics.getStartTime();
        DateTime otherEndTime = otherStatistics.getEndTime();
        DateTime mergedStartTime = this._startTime.isBefore((ReadableInstant)otherStartTime) ? this._startTime : otherStartTime;
        DateTime mergedEndTime = otherEndTime == null ? this._endTime : this.mergeEndTime(otherEndTime);
        int processed = this.getProcessedCount() + otherStatistics.getProcessedCount();
        int inserted = this.getInsertCount() + otherStatistics.getInsertCount();
        int updated = this.getUpdateCount() + otherStatistics.getUpdateCount();
        int skipped = this.getSkippedCount() + otherStatistics.getSkippedCount();
        int failed = this.getFailedCount() + otherStatistics.getFailedCount();
        int successfulImports = this.getSuccessfulImports() + otherStatistics.getSuccessfulImports();
        int failedImports = this.getFailedImports() + otherStatistics.getFailedImports();
        int skippedImports = this.getSkippedImports() + otherStatistics.getSkippedImports();
        ImmutableListMultimap errors = this._errors.putAll(otherStatistics.getErrors()).build();
        return new ImportStatistics(mergedStartTime, mergedEndTime, processed, inserted, updated, failed, skipped, (ImmutableListMultimap<ImportErrorType, String>)errors, successfulImports, failedImports, skippedImports);
    }

    public String toString() {
        return MoreObjects.toStringHelper(ImportStatistics.class).add("insertCount", this._insertCount.get()).add("updateCount", this._updateCount.get()).add("skippedCount", this._skippedCount.get()).add("failedCount", this._failedCount.get()).add("processedCount", this._processedCount.get()).add("successfulImports", this._successfulImports.get()).add("skippedImports", this._skippedImports.get()).add("failedImports", this._failedImports.get()).add("errors", (Object)this._errors.build()).toString();
    }

    public static enum ImportErrorType {
        MISSING_EXTERNAL_ID,
        MISSING_EMAIL,
        MISSING_FIRSTNAME,
        MISSING_LASTNAME,
        INVALID_INTERNAL_ID,
        EXCEPTION,
        DELETED_IN_JUST;

    }
}

