/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.mapper.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class SetCommands {
    private static final Logger LOG = LoggerFactory.getLogger(SetCommands.class);
    private static final Function<Object, String> OBJECT_TO_STRING = input -> {
        if (input != null && !(input instanceof String)) {
            throw new IllegalArgumentException("Type mismatch: Expected string attribute, got " + input.getClass().getName());
        }
        return StringUtils.trimToNull((String)((String)input));
    };

    private SetCommands() {
    }

    @CheckForNull
    public static String getSingleString(List<Object> values) {
        return OBJECT_TO_STRING.apply(Iterables.getFirst(values, null));
    }

    @Nonnull
    public static ImmutableList<String> getMultipleString(List<Object> values) {
        return (ImmutableList)values.stream().map(OBJECT_TO_STRING).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static Predicate<Object> getSaveValuePredicate(boolean synchronize) {
        return input -> input != null || synchronize;
    }

    public static boolean isDisabledByInactiveBitValue(List<Object> values, String inactiveBitParamValue) {
        String value = SetCommands.getSingleString(values);
        if (value != null) {
            Integer inactiveBitValue = SetCommands.decode(inactiveBitParamValue);
            Integer intValue = SetCommands.decode(value);
            if (inactiveBitValue != null && intValue != null) {
                boolean disabled = (intValue & inactiveBitValue) == inactiveBitValue;
                return disabled;
            }
        }
        return true;
    }

    public static boolean getByBooleanValue(List<Object> values) {
        Object value = Iterables.getFirst(values, null);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    @CheckForNull
    public static Integer decode(String value) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not decode value {}", (Object)value);
            return null;
        }
    }
}

