/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="importProcessLockService")
public class ZookeeperImportProcessLockService
implements ImportProcessLockService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperImportProcessLockService.class);
    private static final String ZOOKEEPER_PATH_PREFIX = "/just/import/locks/";
    private final CuratorFramework _zookeeperClient;
    private final int _timeOutSeconds;

    @Autowired
    public ZookeeperImportProcessLockService(CuratorFramework zookeeperClient, @Value(value="${just.import.processLock.timeout:1}") int timeOutSeconds) {
        this._zookeeperClient = zookeeperClient;
        this._timeOutSeconds = Math.max(timeOutSeconds, 1);
    }

    @Override
    public <R> R acquireAndExecute(Supplier<R> f) throws ImportException {
        return this.acquireAndExecute("import", f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R acquireAndExecute(@Nullable String lockId, Supplier<R> f) throws ImportException {
        boolean lockAquired;
        InterProcessMutex mutex = new InterProcessMutex(this._zookeeperClient, ZOOKEEPER_PATH_PREFIX + lockId);
        try {
            lockAquired = mutex.acquire((long)this._timeOutSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Catched exception while aquiring lock for import process " + lockId + ", ignoring the lock, but expect errors!", (Throwable)e);
            return f.get();
        }
        if (!lockAquired) {
            throw new ImportException("Could not acquire lock for import process " + lockId + ", probably an import process is already running.");
        }
        try {
            R r = f.get();
            return r;
        }
        finally {
            try {
                mutex.release();
            }
            catch (Exception e) {
                LOG.warn("Catched Exception during release of lock for import process " + lockId + ", expect further errors!", (Throwable)e);
            }
        }
    }
}

