/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.migration.business.UserGroupMembershipsImportPublisher;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupMembershipsImportPublisherImpl
implements UserGroupMembershipsImportPublisher {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @VisibleForTesting
    static final String MEMBER_TOPIC = "just.people.import.userGroupMembers";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupMembershipsImportPublisherImpl.class);
    private static final ObjectNode EMPTY_JSON_OBJECT = OBJECT_MAPPER.createObjectNode();
    private final KafkaCleaningProducer<String, String> _kafkaProducer;

    public UserGroupMembershipsImportPublisherImpl(@Nullable KafkaCleaningProducer<String, String> kafkaProducer) {
        this._kafkaProducer = kafkaProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, @Nullable Exception exception) {
        if (exception != null) {
            LOGGER.error("Could not publish group data to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    @Override
    public void addProfileIdToUserGroup(ProfileId profileId, UserGroupId userGroupId) {
        if (this._kafkaProducer == null) {
            LOGGER.error("Failed to create record for user group membership (usergroup: " + userGroupId + ", member: " + profileId + "). KafkaProduce == null");
            return;
        }
        try {
            this._kafkaProducer.send(new ProducerRecord(MEMBER_TOPIC, (Object)(profileId.asString() + "@" + userGroupId.toString()), (Object)OBJECT_MAPPER.writeValueAsString((Object)EMPTY_JSON_OBJECT)), this::logErrorCallback);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to create record for user group membership (usergroup: " + userGroupId + ", member: " + profileId + ")", (Throwable)e);
        }
    }

    @Override
    public void removeProfileIdFromUserGroup(ProfileId profileId, UserGroupId userGroupId) {
        if (this._kafkaProducer == null) {
            LOGGER.error("Failed to create record for user group membership (usergroup: " + userGroupId + ", member: " + profileId + "). KafkaProduce == null");
            return;
        }
        this._kafkaProducer.send(new ProducerRecord(MEMBER_TOPIC, (Object)(profileId.asString() + "@" + userGroupId.toString()), null), this::logErrorCallback);
    }
}

