/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.migration.MigrationSettings;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.PersonUpdateEvent;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.SubscriptionImportModel;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

abstract class SubscriptionImportPostProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    private final LikeReadDataService _likeReadService;
    private final LikeWriteDataService _likeWriteService;
    private final EntityService _entityService;
    private final MigrationSettings _migrationSettings;
    private final SubscriptionType _subscriptionType;
    private final SubscriptionImportDataProvider<I> _noopDataProvider = importedData -> ImmutableList.of();
    private SubscriptionImportDataProvider<I> _importDataProvider = this._noopDataProvider;
    private ImmutableSet<EntityId> _defaultEntityIds = ImmutableSet.of();
    private ImmutableSet<EntityType> _entityTypesForSubscriptions = ImmutableSet.of();
    private boolean _useMigrationSettingsDefaultEntityIds = true;
    private boolean _exclusive;

    @Autowired
    @ParametersAreNonnullByDefault
    protected SubscriptionImportPostProcessor(EntityService entityService, LikeReadDataService likeReadService, LikeWriteDataService likeWriteService, MigrationSettings migrationSettings, SubscriptionType subscriptionType, boolean exclusive) {
        this._entityService = entityService;
        this._likeReadService = likeReadService;
        this._likeWriteService = likeWriteService;
        this._migrationSettings = migrationSettings;
        this._subscriptionType = subscriptionType;
        this._exclusive = exclusive;
    }

    public void setImportDataProvider(@Nonnull SubscriptionImportDataProvider<I> importDataProvider) {
        this._importDataProvider = importDataProvider;
    }

    public void setDefaultEntityId(@Nonnull Long id) {
        this.setDefaultEntityIds((List<Long>)ImmutableList.of((Object)id));
    }

    public void setDefaultEntityIds(@Nonnull List<Long> ids) {
        this._defaultEntityIds = FluentIterable.from(ids).transform(EntityId.FROM_LONG).toSet();
    }

    public void setEntityTypesForSubscriptions(@Nonnull List<String> entityTypesForSubscriptions) {
        this._entityTypesForSubscriptions = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Lists.transform(entityTypesForSubscriptions, EntityType.FROM_NAME), (Predicate)Predicates.notNull()));
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    public void setUseMigrationSettingsDefaultEntityIds(boolean useMigrationSettingsDefaultEntityIds) {
        this._useMigrationSettingsDefaultEntityIds = useMigrationSettingsDefaultEntityIds;
    }

    @Override
    public void process(List<? extends I> importModels, ImportUpdateEventCollector importUpdateEventCollector) {
        ImmutableSet<EntityId> configuredDefaultEntities = this.getConfiguredDefaultEntities();
        if (!this._exclusive && this._importDataProvider == this._noopDataProvider && configuredDefaultEntities.isEmpty()) {
            return;
        }
        HashMultimap subscriptionsToImport = HashMultimap.create();
        try {
            Iterable importedSubscriptions = this._importDataProvider.getAdditionalImportDataFor(importModels);
            for (SubscriptionImportModel subscription : importedSubscriptions) {
                subscriptionsToImport.putAll(subscription.getSubscriptions());
            }
            ImmutableSet importedPersonIds = importModels.stream().map(PersonImportModel.TO_PERSON_ID).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
            configuredDefaultEntities.forEach(arg_0 -> SubscriptionImportPostProcessor.lambda$process$1((SetMultimap)subscriptionsToImport, importedPersonIds, arg_0));
            this.importSubscriptions(importUpdateEventCollector, (SetMultimap<EntityId, PersonId>)subscriptionsToImport, (ImmutableSet<PersonId>)importedPersonIds);
        }
        catch (ImportException e) {
            PersonImportService.IMPORT_LOG.error("Error occurred while importing subscriptions. Subscription import aborted for this chunk.", (Throwable)e);
        }
    }

    private ImmutableSet<EntityId> getConfiguredDefaultEntities() {
        if (!this._useMigrationSettingsDefaultEntityIds) {
            return this._defaultEntityIds;
        }
        switch (this._subscriptionType) {
            case PASSIVE: {
                return (ImmutableSet)Stream.concat(this._defaultEntityIds.stream(), this._migrationSettings.getImportPassiveSubscriptionDefaultEntityIds().stream()).collect(ImmutableSet.toImmutableSet());
            }
            case RECOMMENDED: {
                return (ImmutableSet)Stream.concat(this._defaultEntityIds.stream(), this._migrationSettings.getImportRecommendedSubscriptionDefaultEntityIds().stream()).collect(ImmutableSet.toImmutableSet());
            }
        }
        return this._defaultEntityIds;
    }

    private void importSubscriptions(@Nonnull ImportUpdateEventCollector importUpdateEventCollector, @Nonnull SetMultimap<EntityId, PersonId> subscriptionsToImport, @Nonnull ImmutableSet<PersonId> importedPersonIds) {
        ExistingSubscriptionsHandler existingSubscriptionsHandler = new ExistingSubscriptionsHandler(importedPersonIds, subscriptionsToImport);
        Map<EntityId, DBEntity> existingEntities = this.loadExistingEntities(subscriptionsToImport);
        HashSet personsToUpdate = Sets.newHashSet();
        HashSet entitiesToUpdate = Sets.newHashSet();
        for (DBEntity entity : existingEntities.values()) {
            EntityId entityId = entity.getId();
            try {
                if (CollectionUtil.isEmpty(this._entityTypesForSubscriptions) || this._entityTypesForSubscriptions.contains((Object)entity.getType())) {
                    Set<PersonId> newSubscriptionImported = existingSubscriptionsHandler.getNewSubscriptions(entityId);
                    if (newSubscriptionImported.isEmpty()) continue;
                    PersonImportService.IMPORT_LOG.info("Importing subscription for entity {} of type {} for persons {}", new Object[]{entityId, entity.getType(), newSubscriptionImported});
                    if (this._subscriptionType == SubscriptionType.RECOMMENDED) {
                        this._likeWriteService.setSubscriptionWhenTypeDiffers((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)entityId, newSubscriptionImported).build(), SubscriptionState.SUBSCRIBED, this._subscriptionType);
                    } else {
                        this._likeWriteService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)entityId, newSubscriptionImported).build(), SubscriptionState.SUBSCRIBED, this._subscriptionType, true);
                    }
                    personsToUpdate.addAll(subscriptionsToImport.get((Object)entityId));
                    entitiesToUpdate.add(entityId);
                    continue;
                }
                PersonImportService.IMPORT_LOG.info(String.format("Ignoring import of subscription for entity %1$s of type %2$s for person ids %3$s.", entityId, entity.getType().getName(), subscriptionsToImport.get((Object)entityId)));
            }
            catch (DAOException e) {
                PersonImportService.IMPORT_LOG.error(String.format("Could not add subscriptions to entity %1$s for person ids %2$s", entityId, subscriptionsToImport.get((Object)entityId)), (Throwable)e);
            }
        }
        existingSubscriptionsHandler.handleNotImportedSubscriptions(entitiesToUpdate, personsToUpdate);
        importUpdateEventCollector.addUpdateEvents(Iterables.transform((Iterable)personsToUpdate, (Function)Functions.compose(PersonUpdateEvent.FROM_PROFILE_ID, PersonId.AS_PROFILE_ID)));
        importUpdateEventCollector.addUpdateEvents(Iterables.transform((Iterable)entitiesToUpdate, EntityUpdateEvent.FROM_ENTITY_ID));
    }

    @Nonnull
    private Map<EntityId, DBEntity> loadExistingEntities(@Nonnull SetMultimap<EntityId, PersonId> subscriptionsToImport) {
        Map<EntityId, DBEntity> existingEntities;
        Set entityIds = subscriptionsToImport.keySet();
        Sets.SetView notExistingEntities = Sets.difference((Set)entityIds, (existingEntities = this._entityService.getByIds(entityIds)).keySet());
        if (!notExistingEntities.isEmpty()) {
            PersonImportService.IMPORT_LOG.error(String.format("There are no entities with the following ids: %1$s. Could not add subscriptions.", notExistingEntities));
        }
        return existingEntities;
    }

    private static /* synthetic */ void lambda$process$1(SetMultimap subscriptionsToImport, ImmutableSet importedPersonIds, EntityId entityId) {
        subscriptionsToImport.putAll((Object)entityId, (Iterable)importedPersonIds);
    }

    @ParametersAreNonnullByDefault
    private final class ExistingSubscriptionsHandler {
        private final Multimap<EntityId, PersonId> _subscriptionsFromDB;
        private final SetMultimap<EntityId, PersonId> _subscriptionsToImport;

        private ExistingSubscriptionsHandler(ImmutableSet<PersonId> importedPersonIds, SetMultimap<EntityId, PersonId> subscriptionsToImport) {
            this._subscriptionsToImport = subscriptionsToImport;
            this._subscriptionsFromDB = SubscriptionImportPostProcessor.this._likeReadService.getSubscriptionsByEntityTypesAndPersonIds((Set<EntityType>)SubscriptionImportPostProcessor.this._entityTypesForSubscriptions, (Set<PersonId>)importedPersonIds, SubscriptionImportPostProcessor.this._subscriptionType);
        }

        @Nonnull
        public Set<PersonId> getNewSubscriptions(EntityId entityId) {
            return Sets.difference((Set)this._subscriptionsToImport.get((Object)entityId), (Set)Sets.newHashSet((Iterable)this._subscriptionsFromDB.get((Object)entityId)));
        }

        @Nonnull
        private Set<PersonId> getSubscriptionsToDelete(EntityId entityId) {
            return Sets.difference((Set)Sets.newHashSet((Iterable)this._subscriptionsFromDB.get((Object)entityId)), (Set)this._subscriptionsToImport.get((Object)entityId));
        }

        void handleNotImportedSubscriptions(Set<EntityId> entitiesToUpdate, Set<PersonId> personsToUpdate) {
            if (SubscriptionImportPostProcessor.this._exclusive) {
                for (EntityId entityId : this._subscriptionsFromDB.keySet()) {
                    Set<PersonId> subscriptionsToDelete = this.getSubscriptionsToDelete(entityId);
                    if (CollectionUtils.isEmpty(subscriptionsToDelete)) continue;
                    SubscriptionImportPostProcessor.this._likeWriteService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)entityId, subscriptionsToDelete).build(), SubscriptionState.UNSUBSCRIBED, SubscriptionType.DEFAULT, true);
                    personsToUpdate.addAll(subscriptionsToDelete);
                    entitiesToUpdate.add(entityId);
                }
            }
        }
    }

    static interface SubscriptionImportDataProvider<J extends PersonImportModel<?>>
    extends ImportProcessor.ImportDataProvider<J, SubscriptionImportModel> {
    }
}

