/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.migration.business.FieldMapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

@ParametersAreNonnullByDefault
public class PropertiesBasedFieldMapping
implements FieldMapping {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesBasedFieldMapping.class);
    private static final String PARAMETER_SUFFIX = ".parameter";
    private static final Splitter VALUE_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    protected Multimap<String, String> _fieldMapping = HashMultimap.create();
    protected Map<String, Properties> _fieldParameter = new HashMap<String, Properties>();

    public PropertiesBasedFieldMapping(Properties fieldMapping) {
        for (String name : fieldMapping.stringPropertyNames()) {
            if (name.endsWith(PARAMETER_SUFFIX)) {
                String parameterDefinitions = fieldMapping.getProperty(name);
                if (parameterDefinitions == null) continue;
                Properties parameters = new Properties();
                VALUE_SPLITTER.split((CharSequence)parameterDefinitions).forEach(parameterDefinition -> PropertiesBasedFieldMapping.loadPropertiesFromString(parameters, parameterDefinition));
                this._fieldParameter.put(StringUtils.removeEnd((String)name, (String)PARAMETER_SUFFIX), parameters);
                continue;
            }
            String fieldValuesDefinition = fieldMapping.getProperty(name);
            this._fieldMapping.putAll((Object)name, fieldValuesDefinition != null ? VALUE_SPLITTER.split((CharSequence)fieldValuesDefinition) : ImmutableSet.of());
        }
    }

    public PropertiesBasedFieldMapping(String fieldsMappingFile) throws IOException {
        this(PropertiesBasedFieldMapping.loadPropertiesFromFile(fieldsMappingFile));
    }

    private static void loadPropertiesFromString(Properties properties, String input) {
        try {
            properties.load(new StringReader(input));
        }
        catch (IOException ignored) {
            LOG.error("Error loading properties from input \"{}\"", (Object)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static Properties loadPropertiesFromFile(String fieldsMappingFile) throws IOException {
        Properties properties;
        InputStreamReader reader = null;
        InputStream in = null;
        try {
            Properties fieldMapping = new Properties();
            in = ResourceUtils.getURL((String)fieldsMappingFile).openStream();
            reader = new InputStreamReader(in, Charsets.UTF_8);
            fieldMapping.load(reader);
            properties = fieldMapping;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    @Override
    public Set<String> getSourceAttributeNames() {
        return this._fieldMapping.keySet();
    }

    @Override
    public Iterable<String> getJuCoField(String sourceAttributeName) {
        return this._fieldMapping.get((Object)sourceAttributeName);
    }

    @Override
    public ImmutableSet<String> getJuCoFieldNames() {
        return ImmutableSet.copyOf((Collection)this._fieldMapping.values());
    }

    @Override
    public Properties getAttributeParameters(String sourceAttributeName) {
        return this._fieldParameter.get(sourceAttributeName);
    }

    @Override
    public String getSourceAttributeNameByJucoField(String jucoFieldName) {
        Multimap invertedMultimap = Multimaps.invertFrom(this._fieldMapping, (Multimap)HashMultimap.create());
        return (String)Iterables.getFirst((Iterable)invertedMultimap.get((Object)jucoFieldName), null);
    }
}

