/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.server.storage.URLImageFile;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.util.FileUtils;
import de.justsoftware.onx.common.shared.server.util.StorageServerUtil;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.GenericPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModelVisitor;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.toolbox.clock.Clock;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class ProfileImageImportPostProcessor
implements ImportPostProcessor<PersonImportModel<?>> {
    private final StorageServerHelper _storageServerHelper;
    private final PersonService _personService;
    private final Clock _clock;
    private File _imageDirectory;
    private boolean _allowOverride = true;
    private boolean _moveUploadedFile = false;
    private File _moveUploadedFileTargetDir;

    @Autowired
    public ProfileImageImportPostProcessor(StorageServerHelper storageServerHelper, PersonService personService, Clock clock) {
        this._storageServerHelper = storageServerHelper;
        this._personService = personService;
        this._clock = clock;
    }

    @Required
    public void setImageDirectory(@Nonnull File imageDirectory) {
        this._imageDirectory = imageDirectory;
    }

    @Required
    public void setAllowOverride(boolean allowOverride) {
        this._allowOverride = allowOverride;
    }

    public void setMoveUploadedFile(boolean moveUploadedFile) {
        this._moveUploadedFile = moveUploadedFile;
    }

    public void setMoveUploadedFileTargetDir(@Nonnull File moveUploadedFileTargetDir) {
        this._moveUploadedFileTargetDir = moveUploadedFileTargetDir;
    }

    @Nonnull
    @VisibleForTesting
    public File getMoveUploadedFileTargetDir() {
        return this._moveUploadedFileTargetDir;
    }

    @Override
    public void process(List<? extends PersonImportModel<?>> importedPerson, ImportUpdateEventCollector importUpdateEventCollector) {
        File dir = this._imageDirectory;
        if (dir.exists() && dir.isDirectory() && dir.canRead()) {
            for (PersonImportModel<?> personImportModel : importedPerson) {
                try {
                    this.processSingleModel(personImportModel);
                }
                catch (RuntimeException e) {
                    PersonImportService.IMPORT_LOG.error("Could not upload profile image for " + personImportModel.getExternalId(), (Throwable)e);
                }
            }
        } else {
            PersonImportService.IMPORT_LOG.error("Directory {} is not accessible. Aborting import", (Object)dir.getName());
        }
    }

    private void processSingleModel(PersonImportModel<?> importedPerson) {
        String newFilename;
        File importFilename;
        PersonId personId = importedPerson.getPerson().getId();
        String externalId = importedPerson.accept(GetIdForProfileImageGenerationVisitor.INSTANCE);
        String oldImage = this.getExistingProfileImage(personId);
        if (oldImage != null && !this._allowOverride) {
            PersonImportService.IMPORT_LOG.info("A profile image exists for person {} and allow override is set to false. Skipping import of profile image.", (Object)personId);
            return;
        }
        File[] foundProfileImages = this._imageDirectory.listFiles((FilenameFilter)new NameFileFilter((List)Lists.newArrayList((Object[])new String[]{externalId + ".png", externalId + ".gif", externalId + ".jpeg", externalId + ".jpg"}), IOCase.INSENSITIVE));
        if (foundProfileImages != null && foundProfileImages.length > 0 && this.uploadProfileImage(personId, importFilename = foundProfileImages[0], newFilename = StorageServerUtil.createRandomFilenameOfProfileImage(personId, "." + Files.getFileExtension((String)importFilename.getName())))) {
            this._personService.updateImage(personId, newFilename);
            if (oldImage != null) {
                this._storageServerHelper.deleteFileOnStorageServerPermanently(ImageType.USER_IMAGE.getPath(), oldImage);
                PersonImportService.IMPORT_LOG.info("Removed old image {} of person {}", (Object)oldImage, (Object)personId);
            }
            this.moveFile(importFilename);
        }
    }

    private void moveFile(File file) {
        File targetDir = this._moveUploadedFileTargetDir;
        if (this._moveUploadedFile && targetDir != null) {
            try {
                FileUtils.moveFileToDir(file, targetDir, true, this._clock);
                PersonImportService.IMPORT_LOG.info("Successfully moved file {} to dir {}", (Object)file.getName(), (Object)targetDir.getAbsolutePath());
            }
            catch (IOException e) {
                PersonImportService.IMPORT_LOG.error("Could not move file " + file.getName(), (Throwable)e);
            }
        } else {
            PersonImportService.IMPORT_LOG.info("File moval not activated. Not moving " + file.getName());
        }
    }

    @CheckForNull
    private String getExistingProfileImage(PersonId personId) {
        DBPerson dbPerson = this._personService.getPersonById(personId);
        return dbPerson != null ? dbPerson.getImage() : null;
    }

    private boolean uploadProfileImage(PersonId personId, File importFilename, String newFilename) {
        try {
            PersonImportService.IMPORT_LOG.info("Starting uploading profile image {} of person {} to {}", new Object[]{importFilename, personId, newFilename});
            URLImageFile imageFile = StorageServerUtil.createURLImageFile(importFilename.toURI().toURL().toString());
            SaveImageResult result = this._storageServerHelper.saveFileOnStorageServer(imageFile, ImageType.USER_IMAGE.getPath(), newFilename, (Collection<ImageSize>)StorageServerHelper.DEFAULT_IMAGE_SIZES, true);
            if (!result.isOk()) {
                PersonImportService.IMPORT_LOG.error("Error occured while uploading profile image {} of person {}: {}", new Object[]{importFilename, personId, result.getMessage()});
                return false;
            }
            PersonImportService.IMPORT_LOG.info("Successfully uploaded profile image {} of person {} to {}", new Object[]{importFilename, personId, newFilename});
            return true;
        }
        catch (MalformedURLException e) {
            PersonImportService.IMPORT_LOG.error("Could not open profile image {} for person {}", (Object)new Object[]{importFilename, personId}, (Object)e);
            return false;
        }
    }

    private static enum GetIdForProfileImageGenerationVisitor implements PersonImportModelVisitor<String>
    {
        INSTANCE;


        @Override
        public String visitCSVPersonImportModel(CSVPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitLDAPPersonImportModel(LDAPPersonImportModel importModel) {
            return importModel.getExternalIdWithoutDomain();
        }

        @Override
        public String visitDatabasePersonImportModel(DatabasePersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }

        @Override
        public String visitGenericPersonImportModel(GenericPersonImportModel importModel) {
            return (String)importModel.getExternalId();
        }
    }
}

