/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.common.shared.util.UrlUtil;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.migration.business.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.UserData;
import de.justsoftware.onx.person.model.DBPerson;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParametersAreNonnullByDefault
public class NewMemberGreetingImportPostProcessor
implements MembershipImportPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"IMPORTLOG");
    private final MailManager _mailManager;
    private final ServerUrlUtil _serverUrlUtil;
    private final EntityConfigService _entityConfig;

    @Autowired
    public NewMemberGreetingImportPostProcessor(@Qualifier(value="mailManager") MailManager mailManager, ServerUrlUtil serverUrlUtil, EntityConfigService entityConfig) {
        this._mailManager = mailManager;
        this._serverUrlUtil = serverUrlUtil;
        this._entityConfig = entityConfig;
    }

    @Override
    public void process(DBPerson person, DBEntity entity) {
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setClassForTemplateLoading(this.getClass(), "/etc/");
            Template body = cfg.getTemplate("notification_new_membership_body.ftl", new Locale(person.getLanguageId()));
            Template subject = cfg.getTemplate("notification_new_membership_subject.ftl", new Locale(person.getLanguageId()));
            HashMap<String, Object> root = new HashMap<String, Object>();
            UserData user = new UserData(person.getFullName(), person.getFirstName(), person.getLastName(), person.getTitle(), person.getAdditionalTitle(), person.getEmail(), null, null);
            root.put("user", user);
            root.put("event", entity.getName());
            root.put("type", entity.getType().getName());
            root.put("url", UrlUtil.getEntityOverviewUrl(entity, this._serverUrlUtil.getHtmlClientBaseUrl()));
            StringWriter bodyWriter = new StringWriter();
            body.process(root, (Writer)bodyWriter);
            StringWriter subjectWriter = new StringWriter();
            subject.process(root, (Writer)subjectWriter);
            this._mailManager.sendMail(person, ((Object)subjectWriter).toString(), ((Object)bodyWriter).toString(), MailType.ENTITY_NEW_MEMBERSHIP_BY_IMPORT);
            LOGGER.info("Successfully sent email of new membership for entity {} to person {}", (Object)entity.getId(), (Object)person.getEmail());
        }
        catch (IOException e) {
            LOGGER.error("Error loading template file", (Throwable)e);
        }
        catch (TemplateException e) {
            LOGGER.error("Error processing template", (Throwable)e);
        }
    }
}

