/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.migration.business.impl.IdMapper;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.support.AttributeValueCallbackHandler;
import org.springframework.ldap.support.LdapUtils;

public class LDAPRegExpValueExtractor<T>
implements LDAPValueExtractor<T> {
    private Pattern _matchingPattern;
    private String _attributeFieldName;
    private IdMapper<T> _idMapper;

    @Required
    public void setAttributeFieldName(@Nonnull String ldapFieldName) {
        this._attributeFieldName = ldapFieldName;
    }

    @Override
    public String getAttributeFieldName() {
        return this._attributeFieldName;
    }

    @Required
    public void setMatchingPattern(@Nonnull String matchingPattern) {
        this._matchingPattern = Pattern.compile(matchingPattern);
    }

    public void setIdMapper(@Nonnull IdMapper<T> idMapper) {
        this._idMapper = idMapper;
    }

    @Override
    public ImmutableSet<T> getValues(Attributes attributes) {
        Attribute attribute = attributes.get(this._attributeFieldName);
        if (attribute == null) {
            return ImmutableSet.of();
        }
        final ImmutableSet.Builder result = ImmutableSet.builder();
        LdapUtils.iterateAttributeValues((Attribute)attribute, (AttributeValueCallbackHandler)new AttributeValueCallbackHandler(){

            public void handleAttributeValue(String attributeName, Object attributeValue, int index) {
                Matcher matcher = LDAPRegExpValueExtractor.this._matchingPattern.matcher(ObjectUtils.toString((Object)attributeValue));
                if (matcher.matches() && matcher.groupCount() > 0) {
                    result.addAll(LDAPRegExpValueExtractor.this._idMapper.getIdsByExternalKeys(matcher.group(1)));
                }
            }
        });
        return result.build();
    }
}

