/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.LDAPExternalIdUtil;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;

@ParametersAreNonnullByDefault
public class LDAPExternalIdMapper
extends AbstractContextMapper<LDAPPersonIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPExternalIdMapper.class);
    private final ExternalIdField _externalIdField;
    private final DomainResolver _domainResolver;

    public LDAPExternalIdMapper(ExternalIdField externalIdField, DomainResolver domainResolver) {
        this._externalIdField = externalIdField;
        this._domainResolver = domainResolver;
    }

    protected LDAPPersonIdentifier doMapFromContext(DirContextOperations op) {
        try {
            String externalId = LDAPExternalIdUtil.getExternalIdAsString(op, this._externalIdField);
            if (externalId == null) {
                LOG.error("Failed to retrieve external id");
                return null;
            }
            return LDAPPersonIdentifier.fromName(this._externalIdField.getFieldName(), externalId, this._domainResolver.getDomain(op.getDn()));
        }
        catch (NamingException e) {
            LOG.error("Failed to create ldap identifier for person with dn " + op.getDn(), (Throwable)e);
            return null;
        }
    }
}

