/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.naming.directory.Attributes;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.support.LdapUtils;

public class LDAPExactValueExtractor
implements LDAPValueExtractor<String> {
    private String _attributeFieldName;

    @Required
    public void setAttributeFieldName(@Nonnull String ldapFieldName) {
        this._attributeFieldName = ldapFieldName;
    }

    @Override
    public String getAttributeFieldName() {
        return this._attributeFieldName;
    }

    @Override
    public ImmutableSet<String> getValues(Attributes attributes) {
        HashSet result = Sets.newHashSet();
        try {
            LdapUtils.collectAttributeValues((Attributes)attributes, (String)this._attributeFieldName, (Collection)result, String.class);
            return ImmutableSet.copyOf((Collection)result);
        }
        catch (NamingException e) {
            PersonImportService.IMPORT_LOG.error("Failed to extract attribute value", (Throwable)e);
            return ImmutableSet.of();
        }
    }
}

