/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.events.UpdateEvent;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class ImportUpdateEventCollector
implements ServerEventCollector {
    private final Set<UpdateEvent<?>> _updateEvents = Sets.newHashSet();
    private final List<ServerEvent> _serverEvents = Lists.newLinkedList();

    public void add(@Nonnull UpdateEvent<?> event) {
        this._updateEvents.add(event);
    }

    public void addUpdateEvents(@Nonnull Iterable<? extends UpdateEvent<?>> events) {
        Iterables.addAll(this._updateEvents, (Iterable)Iterables.filter(events, (Predicate)Predicates.notNull()));
    }

    public void addServerEvents(@Nonnull Iterable<? extends ServerEvent> events) {
        Iterables.addAll(this._serverEvents, (Iterable)Iterables.filter(events, (Predicate)Predicates.notNull()));
    }

    @Override
    public void add(ServerEvent event) {
        this._serverEvents.add(event);
    }

    public void clear() {
        this._updateEvents.clear();
        this._serverEvents.clear();
    }

    @Nonnull
    public ImmutableSet<UpdateEvent<?>> getUpdateEvents() {
        return ImmutableSet.copyOf(this._updateEvents);
    }

    @Nonnull
    public ImmutableList<ServerEvent> getServerEvents() {
        return ImmutableList.copyOf(this._serverEvents);
    }

    public boolean isEmpty() {
        return this._serverEvents.isEmpty() && this._updateEvents.isEmpty();
    }
}

