/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.ImportService;
import de.justsoftware.onx.migration.business.ImportServiceQueue;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.monitoring.business.ImportQueueStatusFlag;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.toolbox.clock.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ImportServiceQueueImpl
implements ImportServiceQueue {
    static final String IMPORT_QUEUE = "importQueue";
    private static final Logger IMPORT_LOG = LoggerFactory.getLogger((String)"IMPORTLOG");
    private ImmutableList<ImportService> _importServices = ImmutableList.of();
    private final Clock _clock;
    private final ClusterConfiguration _clusterConfiguration;
    private final AtomicBoolean _importRunning = new AtomicBoolean();
    private final ImportProcessLockService _importProcessLockService;
    private final ImportQueueStatusFlag _statusFlag;

    @Autowired
    public ImportServiceQueueImpl(Clock clock, ClusterConfiguration clusterConfiguration, ImportProcessLockService importProcessLockService, ImportQueueStatusFlag statusFlag) {
        this._clock = clock;
        this._clusterConfiguration = clusterConfiguration;
        this._importProcessLockService = importProcessLockService;
        this._statusFlag = statusFlag;
    }

    @Resource(name="importQueue")
    public void setServices(Iterable<? extends ImportService> importServices) {
        this._importServices = ImmutableList.copyOf(importServices);
    }

    @Override
    public boolean isRunning() {
        return this._importRunning.get();
    }

    @Override
    public void startImport() {
        if (this._clusterConfiguration.isMaster()) {
            if (this._importRunning.compareAndSet(false, true)) {
                try {
                    this.startImportInternal();
                }
                finally {
                    this._importRunning.set(false);
                }
            } else {
                IMPORT_LOG.error("Import Queue: Cannot start processing of import queue because import is already running.");
            }
        }
    }

    @Nonnull
    @VisibleForTesting
    ImportStatistics startImportInternal() {
        ImportStatistics overallStatistics = new ImportStatistics(this._clock.now());
        int totalImports = this._importServices.size();
        IMPORT_LOG.info("Import Queue: Start processing import queue with {} import services.", (Object)totalImports);
        for (ImportService importService : this._importServices) {
            try {
                if (importService.isEnabled()) {
                    ImportStatistics statistics = this._importProcessLockService.acquireAndExecute(() -> importService.doImport());
                    overallStatistics = overallStatistics.merge(statistics);
                } else {
                    overallStatistics.incSkippedImports();
                    IMPORT_LOG.info("Import Queue: Skipping disabled import service '{}'.", (Object)importService.getClass().getCanonicalName());
                }
                if (overallStatistics.getFailedImports() <= 0) continue;
                this._statusFlag.setFailed(true);
                IMPORT_LOG.error("Import Queue: A fatal error occurred while executing the importService '{}'. All subsequent imports will be aborted. {}", (Object)importService.getClass().getCanonicalName(), (Object)overallStatistics.toString());
                return overallStatistics;
            }
            catch (ImportException e) {
                this._statusFlag.setFailed(true);
                overallStatistics.incFailedImports();
                IMPORT_LOG.error("Import Queue: A fatal error occurred while acquiring the process lock for '" + importService.getClass().getCanonicalName() + "'. All subsequent imports will be aborted. " + overallStatistics, (Throwable)e);
                return overallStatistics;
            }
        }
        this._statusFlag.setFailed(false);
        if (overallStatistics.getSkippedImports() == 0) {
            IMPORT_LOG.info("Import Queue: All imports finished successfully.");
        } else {
            IMPORT_LOG.info("Import Queue: Finished. Skipped {} imports, because they are disabled.", (Object)overallStatistics.getSkippedImports());
        }
        return overallStatistics;
    }
}

