/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.impl.SuperopertyJobTriggerBean;
import de.justsoftware.onx.common.business.impl.SuperopertyRescheduler;
import de.justsoftware.onx.migration.business.ImportService;
import de.justsoftware.onx.migration.business.ImportServiceQueue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

@Configuration
@ParametersAreNonnullByDefault
public class ImportServiceQueueConfiguration {
    private static final String IMPORT_QUEUE_JOB_TRIGGER = "importQueueJobTrigger";
    private static final String IMPORT_QUEUE_JOB_DETAIL = "importQueueJobDetail";

    @Bean(name={"importQueueJobDetail"})
    @Nonnull
    public FactoryBean<JobDetail> importQueueJobDetail(ImportServiceQueue importServiceQueue) {
        MethodInvokingJobDetailFactoryBean result = new MethodInvokingJobDetailFactoryBean();
        result.setTargetObject((Object)importServiceQueue);
        result.setTargetMethod("startImport");
        result.setConcurrent(false);
        return result;
    }

    @Bean(name={"importQueueJobTrigger"})
    @Nonnull
    public SuperopertyJobTriggerBean importQueueJobTrigger(Settings settings, @Qualifier(value="importQueueJobDetail") JobDetail importServiceQueueJobDetail) {
        SuperopertyJobTriggerBean cronTriggerFactoryBean = new SuperopertyJobTriggerBean();
        cronTriggerFactoryBean.setJobDetail(importServiceQueueJobDetail);
        cronTriggerFactoryBean.setCronExpressionProperty(settings.getImportQueueCronJobExpressionProperty());
        cronTriggerFactoryBean.setMisfireInstruction(2);
        return cronTriggerFactoryBean;
    }

    @Bean
    @Nonnull
    public SuperopertyRescheduler importQueueSuperopertyRescheduler(@Qualifier(value="defaultScheduler") Scheduler scheduler, @Qualifier(value="importQueueJobTrigger") CronTrigger importServiceQueueJobTrigger, Settings settings) {
        SuperopertyRescheduler superopertyRescheduler = new SuperopertyRescheduler();
        superopertyRescheduler.setScheduler(scheduler);
        superopertyRescheduler.setTrigger(importServiceQueueJobTrigger);
        superopertyRescheduler.setCronExpressionProperty(settings.getImportQueueCronJobExpressionProperty());
        return superopertyRescheduler;
    }

    @Bean(name={"importQueue"})
    @Nonnull
    public List<ImportService> importServiceQueue() {
        return ImmutableList.of();
    }
}

