/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.business.TenantService;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ImportConfiguration {
    @Bean
    @Nonnull
    public RestTemplate importRestTemplate(@Value(value="${just-import.connection.readtimeoutms:3600000}") int readTimeout, @Value(value="${just-import.connection.connecttimeoutms:10000}") int connectTimeout) {
        return new RestTemplate(this.clientHttpRequestFactory(readTimeout, connectTimeout));
    }

    @Nonnull
    private ClientHttpRequestFactory clientHttpRequestFactory(int readTimeout, int connectTimeout) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setReadTimeout(readTimeout);
        requestFactory.setConnectTimeout(connectTimeout);
        return requestFactory;
    }

    @Profile(value={"!integration-test"})
    @Bean(name={"importTenantIdSupplier"})
    public Supplier<TenantId> importTenantIdSupplier(TenantService tenantService) {
        return Suppliers.memoize(() -> tenantService.getOnlyTenant().orElseThrow(() -> new IllegalArgumentException("Default import config only works with exactly one tenant. Please onfigure a importTenantIdSupplier in appContext when working with more than one tenant.")));
    }

    @Profile(value={"integration-test"})
    @Nonnull
    @Bean(name={"importTenantIdSupplier"})
    public Supplier<TenantId> testImportTenantIdSupplier(TenantService tenantService) {
        return () -> tenantService.getOnlyTenant().orElseThrow(() -> new IllegalArgumentException("Default import config only works with exactly one tenant. Please onfigure a importTenantIdSupplier in appContext when working with more than one tenant."));
    }
}

