/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.impl.IdMapper;
import de.justsoftware.onx.migration.integration.persistence.EntityImportDAO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ExternalEntityIdToEntityIdMapper
implements IdMapper<EntityId> {
    @Autowired
    private EntityImportDAO<String> _entityImportDAO;
    private String _splitRegEx = null;

    public void setSplitRegEx(@Nullable String splitRegEx) {
        this._splitRegEx = splitRegEx;
    }

    @Nonnull
    private ImmutableSet<EntityId> getEntityIdsFromExternalIds(String ... externalIdsArray) {
        ImmutableList externalIds = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(Arrays.asList(externalIdsArray), (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input == null) {
                    return null;
                }
                return input.trim().toLowerCase();
            }
        }), (Predicate)Predicates.notNull()));
        Map<String, EntityId> entityIds = this._entityImportDAO.getInternalIds((Collection<String>)externalIds);
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)externalIds, (Function)Functions.forMap(entityIds, null)), (Predicate)Predicates.notNull()));
    }

    @Override
    public ImmutableSet<EntityId> getIdsByExternalKeys(String keys) {
        if (this._splitRegEx != null) {
            return this.getEntityIdsFromExternalIds(keys.split(this._splitRegEx));
        }
        return this.getEntityIdsFromExternalIds(keys);
    }
}

