/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.container.business.EntityReadWriteDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.events.EntityParentsChangedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.events.EntityParentUpdateEvent;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.migration.business.EntityParentImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.shared.server.model.EntityImportModel;
import de.justsoftware.onx.migration.shared.server.model.LDAPEntityImportModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class EntityParentImportPostProcessorImpl
implements EntityParentImportPostProcessor {
    private static final Logger IMPORT_LOG = PersonImportService.IMPORT_LOG;
    private static final int MAX_IMPORT_RETRY_TIMES = 3;
    @Autowired
    private EntityReadWriteDataService _entityReadWriteDataService;
    @Autowired
    private EntityService _entityService;
    private LDAPValueExtractor<EntityId> _parentIdsValueExtractor;

    @Required
    public void setParentIdsValueExtractor(@Nonnull LDAPValueExtractor<EntityId> parentIdsValueExtractor) {
        this._parentIdsValueExtractor = parentIdsValueExtractor;
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void process(List<? extends LDAPEntityImportModel<String>> importModels, ImportUpdateEventCollector updateEventCollector) {
        IMPORT_LOG.info("Start importing entity parents");
        ArrayList<LDAPEntityImportModel<String>> allSuccessfullyImportModels = new ArrayList<LDAPEntityImportModel<String>>(importModels.size());
        ImmutableSetMultimap<EntityId, EntityId> parents = this.determineParents(importModels);
        ImportResult importResult = this.importEntityParents(importModels, parents, updateEventCollector);
        allSuccessfullyImportModels.addAll(importResult.getImportedModels());
        for (int i = 1; i < 3 && !importResult.getInvalidImports().isEmpty() && !importResult.getImportedModels().isEmpty(); ++i) {
            importResult = this.importEntityParents(importResult.getInvalidImports(), parents, updateEventCollector);
            allSuccessfullyImportModels.addAll(importResult.getImportedModels());
        }
        ImmutableSet entitiesToUpdate = ImmutableSet.copyOf((Iterable)Iterables.transform(allSuccessfullyImportModels, EntityImportModel.TO_ENTITY_ID));
        updateEventCollector.addUpdateEvents(Iterables.transform((Iterable)entitiesToUpdate, EntityUpdateEvent.FROM_ENTITY_ID));
        updateEventCollector.addUpdateEvents(Iterables.transform((Iterable)entitiesToUpdate, EntityParentUpdateEvent.TO_ENTITY_PARENT_UPDATE_EVENT));
        IMPORT_LOG.info("The following entity parents have been imported successfully:\n{}", (Object)this.createLogOutput(allSuccessfullyImportModels));
        List<LDAPEntityImportModel<String>> invalid = importResult.getInvalidImports();
        if (!invalid.isEmpty()) {
            IMPORT_LOG.warn("Failed to import parents for following entities because defined parents cause recursions:\n{}", (Object)this.createLogOutput(invalid));
        }
        IMPORT_LOG.info("Importing entity parents done");
    }

    @Nonnull
    private ImmutableSetMultimap<EntityId, EntityId> determineParents(@Nonnull List<? extends LDAPEntityImportModel<String>> importModels) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (LDAPEntityImportModel<String> lDAPEntityImportModel : importModels) {
            ImmutableSet<EntityId> parentIds = this._parentIdsValueExtractor.getValues(lDAPEntityImportModel.getAttributes());
            builder.putAll((Object)lDAPEntityImportModel.getEntity().getEntityId(), parentIds);
        }
        return builder.build();
    }

    private String createLogOutput(@Nonnull List<LDAPEntityImportModel<String>> importModels) {
        StringBuilder sb = new StringBuilder();
        for (LDAPEntityImportModel<String> importModel : importModels) {
            sb.append("Entity (").append((String)importModel.getExternalId()).append(") with entity id: ").append(importModel.getEntity().getEntityId()).append("\n");
        }
        return sb.toString();
    }

    @Nonnull
    private ImportResult importEntityParents(@Nonnull List<? extends LDAPEntityImportModel<String>> importModels, @Nonnull ImmutableSetMultimap<EntityId, EntityId> parents, @Nonnull ImportUpdateEventCollector updateEventCollector) {
        ArrayList<LDAPEntityImportModel<String>> invalidImports = new ArrayList<LDAPEntityImportModel<String>>(importModels.size());
        ArrayList<LDAPEntityImportModel<String>> successfullyImports = new ArrayList<LDAPEntityImportModel<String>>(importModels.size());
        for (LDAPEntityImportModel<String> lDAPEntityImportModel : importModels) {
            String externalId = (String)lDAPEntityImportModel.getExternalId();
            if (externalId == null) {
                IMPORT_LOG.error("Import model without Id. Illegal State. ImportModel will be skipped");
                continue;
            }
            EntityId entityId = lDAPEntityImportModel.getEntity().getEntityId();
            DBEntity entity = this._entityService.getById(entityId);
            if (entity != null) {
                ImmutableSet newParents = parents.get((Object)entityId);
                switch (this.checkParents(entity, (Set<EntityId>)newParents)) {
                    case INVALID_FOR_UPDATE: {
                        invalidImports.add(lDAPEntityImportModel);
                        break;
                    }
                    case VALID_FOR_UPDATE: {
                        if (!this.updateEntityParents(externalId, entity, (ImmutableSet<EntityId>)newParents, updateEventCollector)) break;
                        successfullyImports.add(lDAPEntityImportModel);
                        break;
                    }
                }
                continue;
            }
            IMPORT_LOG.warn("No entity found for import model with externalId " + (String)lDAPEntityImportModel.getExternalId() + " and entityId " + entityId + ". Parents will not imported for this entity.");
        }
        return new ImportResult(invalidImports, successfullyImports);
    }

    private boolean updateEntityParents(@Nonnull String externalId, @Nonnull DBEntity entity, @Nonnull ImmutableSet<EntityId> newParents, ImportUpdateEventCollector updateEventCollector) {
        try {
            ArrayList<DBEntityLink> parents = new ArrayList<DBEntityLink>(newParents.size());
            for (EntityId parentId : newParents) {
                parents.add(new DBEntityLink(parentId, false, false));
            }
            entity.setLinkedEntities(parents);
            this._entityReadWriteDataService.updateEntity(entity);
            updateEventCollector.add(new EntityParentsChangedEvent(entity.getId(), !newParents.isEmpty(), false, false));
            return true;
        }
        catch (RuntimeException e) {
            IMPORT_LOG.error("Couldn't update parents of entity with entityId:" + entity.getId() + " and externalId " + externalId, (Throwable)e);
            return false;
        }
    }

    @Override
    public EntityParentImportPostProcessor.ParentCheckStatus checkParents(DBEntity entity, Set<EntityId> newParents) {
        Set<EntityId> oldParents = entity.getLinkedEntityIds();
        if (newParents.size() == oldParents.size() && newParents.containsAll(oldParents)) {
            return EntityParentImportPostProcessor.ParentCheckStatus.NO_NEED_TO_UDATE;
        }
        HashSet<EntityId> newAddedParents = new HashSet<EntityId>(newParents);
        newAddedParents.removeAll(oldParents);
        if (newAddedParents.isEmpty()) {
            return EntityParentImportPostProcessor.ParentCheckStatus.VALID_FOR_UPDATE;
        }
        RecursionCheckSearchPredicates recursionCheckSearchPredicates = new RecursionCheckSearchPredicates(entity.getId());
        for (EntityId newParentEntityId : newParents) {
            if (!this._entityService.searchParents(newParentEntityId, (EntityService.SearchPredicates)recursionCheckSearchPredicates).hasNext()) continue;
            return EntityParentImportPostProcessor.ParentCheckStatus.INVALID_FOR_UPDATE;
        }
        return EntityParentImportPostProcessor.ParentCheckStatus.VALID_FOR_UPDATE;
    }

    private static class ImportResult {
        private final List<LDAPEntityImportModel<String>> _invalidImports;
        private final List<LDAPEntityImportModel<String>> _importedModels;

        public ImportResult(@Nonnull List<LDAPEntityImportModel<String>> invalidImports, @Nonnull List<LDAPEntityImportModel<String>> importedModels) {
            this._invalidImports = invalidImports;
            this._importedModels = importedModels;
        }

        public List<LDAPEntityImportModel<String>> getInvalidImports() {
            return this._invalidImports;
        }

        public List<LDAPEntityImportModel<String>> getImportedModels() {
            return this._importedModels;
        }
    }

    private static final class RecursionCheckSearchPredicates
    implements EntityService.SearchPredicates {
        private final EntityId _ownEntityId;

        private RecursionCheckSearchPredicates(@Nonnull EntityId ownEntityId) {
            this._ownEntityId = ownEntityId;
        }

        @Override
        public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
            return this._ownEntityId.equals(e.getId());
        }

        @Override
        public boolean expand(DBEntity e, int depth, EntityId childBefore) {
            return !this._ownEntityId.equals(e.getId());
        }
    }
}

