/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.ExternalIdResolver;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
class DomainAwareExternalIdResolver
implements ExternalIdResolver {
    private DomainResolver _domainResolver;
    private String _externalIdColName;

    DomainAwareExternalIdResolver() {
    }

    @Required
    public void setExternalIdColName(String externalIdColName) {
        this._externalIdColName = externalIdColName;
    }

    @Required
    public void setDomainResolver(DomainResolver domainResolver) {
        this._domainResolver = domainResolver;
    }

    @Override
    public String resolveExternalId(@Nullable String csvExternalId) {
        if (csvExternalId == null) {
            return null;
        }
        return LDAPPersonIdentifier.fromName(this._externalIdColName, csvExternalId, this._domainResolver.getDomain(csvExternalId)).toExternalIdString();
    }
}

