/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.migration.business.FieldMapping;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.MappingBasedPersonImportDataProvider;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.integration.persistence.PersonImportDAO;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

@ParametersAreNonnullByDefault
public class DatabasePersonImportDataProvider
extends MappingBasedPersonImportDataProvider<DatabasePersonImportModel> {
    protected final PersonImportDAO _personImportDAO;
    private String _externalIdColName;

    @Autowired
    public DatabasePersonImportDataProvider(PersonImportDAO personImportDAO) throws ImportException {
        this._personImportDAO = personImportDAO;
    }

    @Required
    public void setExternalIdColName(String externalIdColName) {
        this._externalIdColName = externalIdColName;
    }

    @Override
    public Iterable<List<DatabasePersonImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        List<Map<String, Object>> users = this._personImportDAO.getImportModels();
        statistics.incProcessed(users.size());
        List importModels = users.stream().map(user -> {
            try {
                return this.mapToImportModel((Map<String, Object>)user, statistics);
            }
            catch (ImportException e) {
                PersonImportService.IMPORT_LOG.error("Error mapping import result to ImportModel: " + user);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return ImmutableList.of(importModels);
    }

    @CheckForNull
    protected DatabasePersonImportModel mapToImportModel(Map<String, Object> row, ImportStatistics statistics) throws ImportException {
        FieldMapping fieldMapping = this.getFieldMapping();
        Object externalId = row.get(this._externalIdColName);
        String email = fieldMapping.getSourceAttributeNameByJucoField("person.email");
        if (externalId == null) {
            PersonImportService.IMPORT_LOG.warn("No external id specified. Skipping this person.");
            statistics.incSkipped(ImportStatistics.ImportErrorType.MISSING_EXTERNAL_ID, (String)row.get(email));
            return null;
        }
        DatabasePersonImportModel person = new DatabasePersonImportModel(new DBPerson(), externalId.toString(), row);
        for (String attributeName : fieldMapping.getSourceAttributeNames()) {
            try {
                Object value = row.get(attributeName);
                for (String juCoFieldName : fieldMapping.getJuCoField(attributeName)) {
                    person.getImportedValues().put((Object)juCoFieldName, value);
                    person.addFieldParameters(juCoFieldName, fieldMapping.getAttributeParameters(attributeName));
                    if (!juCoFieldName.equals("person.password")) continue;
                    person.setPlainPassword(StringUtils.stripToNull((String)((String)value)));
                }
            }
            catch (RuntimeException e) {
                PersonImportService.IMPORT_LOG.error("Could not get attribute with name " + attributeName + ". Skipping this attribute.", (Throwable)e);
            }
        }
        return person;
    }
}

