/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.impl.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.integration.persistence.PersonImportDAO;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.migration.integration.persistence.ibatis.PersonEntityMappingIbatisModel;
import de.justsoftware.onx.migration.shared.server.model.DatabasePersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class DatabaseMembershipImportDataProvider
implements MembershipImportPostProcessor.MembershipImportDataProvider<DatabasePersonImportModel> {
    private final PersonImportDAO _personImportDAO;
    private final PersonImportMappingDAO _personImportMappingDAO;

    @Autowired
    public DatabaseMembershipImportDataProvider(PersonImportDAO personImportDAO, PersonImportMappingDAO personImportMappingDAO) {
        this._personImportDAO = personImportDAO;
        this._personImportMappingDAO = personImportMappingDAO;
    }

    @Override
    public Iterable<MembershipImportModel> getAdditionalImportDataFor(List<? extends DatabasePersonImportModel> importedData) throws ImportException {
        Set<String> externalIds = PersonImportModel.toExternalIdsOfActiveUsers(importedData);
        List<PersonEntityMappingIbatisModel> memberships = this._personImportDAO.getMembershipsByExternalIds(externalIds);
        if (memberships.isEmpty()) {
            return ImmutableList.of();
        }
        Map<String, PersonId> internalIds = this._personImportMappingDAO.getInternalIds(externalIds);
        PersonImportService.IMPORT_LOG.info("Importing {} memberships", (Object)memberships.size());
        return memberships.stream().map(m -> MembershipImportModel.fromPersonEntityRelation(m, internalIds)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

