/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.impl.CSVMultiValueExtractor;
import de.justsoftware.onx.migration.business.impl.SubscriptionImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.migration.shared.server.model.SubscriptionImportModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class CSVSubscriptionImportDataProvider
implements SubscriptionImportPostProcessor.SubscriptionImportDataProvider<CSVPersonImportModel> {
    private CSVMultiValueExtractor<EntityId> _extractor;

    @Required
    public void setCSVMultiValueExtractor(@Nonnull CSVMultiValueExtractor<EntityId> extractor) {
        this._extractor = extractor;
    }

    @Override
    public Iterable<SubscriptionImportModel> getAdditionalImportDataFor(List<? extends CSVPersonImportModel> importedData) {
        HashSet<SubscriptionImportModel> subscriptionImportModels = new HashSet<SubscriptionImportModel>();
        for (CSVPersonImportModel cSVPersonImportModel : importedData) {
            ImmutableSet<EntityId> entityIdList = this._extractor.getValues(cSVPersonImportModel.getRow());
            subscriptionImportModels.add(new SubscriptionImportModel((Set<EntityId>)entityIdList, (Set<PersonId>)ImmutableSet.of((Object)cSVPersonImportModel.getPerson().getId())));
        }
        return subscriptionImportModels;
    }
}

