/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.impl.CSVMultiValueExtractor;
import de.justsoftware.onx.migration.business.impl.StaticRoleImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class CSVRoleImportDataProvider
implements StaticRoleImportPostProcessor.StaticRoleImportDataProvider<CSVPersonImportModel> {
    private CSVMultiValueExtractor<String> _extractor;

    @Required
    public void setCSVMultiValueExtractor(@Nonnull CSVMultiValueExtractor<String> extractor) {
        this._extractor = extractor;
    }

    @Override
    public Iterable<StaticRoleImportPostProcessor.StaticRoleImportModel> getAdditionalImportDataFor(List<? extends CSVPersonImportModel> importedPersons) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (CSVPersonImportModel cSVPersonImportModel : importedPersons) {
            result.add((Object)this.getImportedRoleNames(cSVPersonImportModel));
        }
        return result.build();
    }

    @Nonnull
    private StaticRoleImportPostProcessor.StaticRoleImportModel getImportedRoleNames(@Nonnull CSVPersonImportModel importedPerson) {
        ImmutableSet<String> roleNames = this._extractor.getValues(importedPerson.getRow());
        return new StaticRoleImportPostProcessor.StaticRoleImportModel((ImmutableSet<PersonId>)ImmutableSet.of((Object)importedPerson.getPerson().getId()), roleNames);
    }
}

