/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Streams;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.business.CSVImportDataProvider;
import de.justsoftware.onx.migration.business.FieldMapping;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ExternalIdResolver;
import de.justsoftware.onx.migration.business.impl.MappingBasedPersonImportDataProvider;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import de.justsoftware.onx.person.model.DBPerson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.ResourceUtils;

@ParametersAreNonnullByDefault
public class CSVPersonImportDataProvider
extends MappingBasedPersonImportDataProvider<CSVPersonImportModel>
implements CSVImportDataProvider {
    private String _csvFilename;
    private String _externalIdColName;
    private Optional<Character> _delimiter = Optional.empty();
    private ExternalIdResolver _externalIdResolver = DefaultExternalIdResolver.INSTANCE;

    @Deprecated
    public void setCharset(String charset) {
        PersonImportService.IMPORT_LOG.warn("Setting the charset manually is deprecated. Remove the call from the application-context. The setting has no effect and the charset will be automatically detected.");
    }

    @Override
    public String getCsvFilename() {
        return this._csvFilename;
    }

    @Required
    public void setCsvFilename(String fileName) {
        this._csvFilename = fileName;
    }

    @Required
    public void setExternalIdColName(String externalIdColName) {
        this._externalIdColName = externalIdColName;
    }

    public void setDelimiter(char delimiter) {
        this._delimiter = Optional.of(Character.valueOf(delimiter));
    }

    public void setExternalIdResolver(ExternalIdResolver externalIdResolver) {
        this._externalIdResolver = externalIdResolver;
    }

    @Override
    public Iterable<List<CSVPersonImportModel>> getImportModels(ImportStatistics statistics) throws ImportException {
        return this.getImportModelsFromFile(this._csvFilename, statistics);
    }

    private Optional<Charset> detectCharset(String pathToFile) throws IOException {
        File importFile = ResourceUtils.getFile((String)pathToFile);
        String detectCharset = UniversalDetector.detectCharset((File)importFile);
        if (detectCharset == null) {
            PersonImportService.IMPORT_LOG.warn("Couldn't detect the encoding for the import file. Assume ASCII.");
            return Optional.of(Charsets.US_ASCII);
        }
        if (!Charset.isSupported(detectCharset)) {
            PersonImportService.IMPORT_LOG.error("The detected encoding '{}' is not supported by this JVM.", (Object)detectCharset);
            return Optional.empty();
        }
        Charset detectedCharset = Charset.forName(detectCharset);
        return Optional.of(detectedCharset);
    }

    private BOMInputStream getInputStreamWithoutBOM(InputStream stream) throws FileNotFoundException {
        return new BOMInputStream(stream, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"}, justification="Auto-Closeable and try-with-resource is no problem.")
    private char guessDelimiter(String path, Charset charset) throws IOException {
        try (BOMInputStream importFile = this.getInputStreamWithoutBOM(new FileInputStream(ResourceUtils.getFile((String)path)));){
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)importFile, (Charset)charset);
            while (lineIterator.hasNext()) {
                String currentLine = lineIterator.nextLine();
                if (currentLine.trim().isEmpty()) continue;
                if (currentLine.contains(";")) {
                    char c = ';';
                    return c;
                }
                char c = ',';
                return c;
            }
        }
        throw new EOFException("File '" + path + "' appears to be empty or only contain empty lines. Expected at least a header line.");
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    protected Iterable<List<CSVPersonImportModel>> getImportModelsFromFile(String csvFilename, ImportStatistics statistics) throws ImportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void mapToImportModel(Consumer<CSVPersonImportModel> consumer, ImportStatistics statistics, @Nullable CSVRecord csvRow, Map<String, Integer> headerMap, FieldMapping fieldMapping) {
        if (csvRow == null) {
            return;
        }
        boolean empty = Streams.stream((Iterator)csvRow.iterator()).allMatch(StringUtils::isBlank);
        if (empty) {
            return;
        }
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
        for (String headerKey : headerMap.keySet()) {
            row.put(headerKey, csvRow.get(headerKey));
        }
        statistics.incProcessed(1);
        String externalId = this._externalIdResolver.resolveExternalId((String)row.get(this._externalIdColName));
        if (StringUtil.isBlank(externalId)) {
            String emailField = fieldMapping.getSourceAttributeNameByJucoField("person.email");
            String email = (String)row.get(emailField);
            String identifier = "Record " + csvRow.getRecordNumber();
            if (email != null) {
                identifier = identifier + ": " + email;
            }
            statistics.incSkipped(ImportStatistics.ImportErrorType.MISSING_EXTERNAL_ID, identifier);
            PersonImportService.IMPORT_LOG.warn("No external id specified. Skipping this person.");
            return;
        }
        CSVPersonImportModel person = new CSVPersonImportModel(new DBPerson(), externalId);
        person.setRow(row);
        for (String attributeName : fieldMapping.getSourceAttributeNames()) {
            try {
                String value = StringUtils.stripToNull((String)person.getRow().get(attributeName));
                for (String juCoFieldName : fieldMapping.getJuCoField(attributeName)) {
                    person.getImportedValues().put((Object)juCoFieldName, (Object)value);
                    person.addFieldParameters(juCoFieldName, fieldMapping.getAttributeParameters(attributeName));
                    if (!juCoFieldName.equals("person.password")) continue;
                    person.setPlainPassword(value);
                }
            }
            catch (RuntimeException e) {
                PersonImportService.IMPORT_LOG.error("Could not get attribute with name " + attributeName + ". Skipping this attribute.", (Throwable)e);
            }
        }
        consumer.accept(person);
    }

    static enum DefaultExternalIdResolver implements ExternalIdResolver
    {
        INSTANCE;


        @Override
        public String resolveExternalId(String csvExternalId) {
            return csvExternalId;
        }
    }
}

