/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.migration.business.impl.CSVMultiValueExtractor;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.impl.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.CSVPersonImportModel;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public class CSVMembershipImportDataProvider
implements MembershipImportPostProcessor.MembershipImportDataProvider<CSVPersonImportModel> {
    private CSVMultiValueExtractor<EntityId> _extractor;

    @Required
    public void setCSVMultiValueExtractor(@Nonnull CSVMultiValueExtractor<EntityId> extractor) {
        this._extractor = extractor;
    }

    @Override
    public Iterable<MembershipImportModel> getAdditionalImportDataFor(List<? extends CSVPersonImportModel> importedPersons) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (CSVPersonImportModel cSVPersonImportModel : importedPersons) {
            result.add((Object)this.getImportedEntityIds(cSVPersonImportModel));
        }
        return result.build();
    }

    @Nonnull
    private MembershipImportModel getImportedEntityIds(@Nonnull CSVPersonImportModel importedPerson) {
        ImmutableSet<EntityId> entities = this._extractor.getValues(importedPerson.getRow());
        return new MembershipImportModel(entities, (ImmutableSet<PersonId>)ImmutableSet.of((Object)importedPerson.getPerson().getId()));
    }
}

