/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.migration.business.CSVExportGeneratedAccountsImportPostProcessorConfiguration;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.toolbox.clock.Clock;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class CSVExportGeneratedAccountsImportPostProcessor
implements ImportPostProcessor<PersonImportModel<?>>,
CSVExportGeneratedAccountsImportPostProcessorConfiguration {
    private static final Joiner ERROR_JOINER = Joiner.on((char)';').useForNull("null");
    private final Clock _clock;
    private String _outputFilename = "/home/justsoftware/generated-accounts.csv";
    private boolean _identifiedByEmail = false;
    private String _idColumnName = "id";
    private String _givenNameColumnName = "given name";
    private String _surnameColumnName = "surname";
    private String _emailColumnName = "email";
    private String _passwordColumnName = "password";
    private String _dateColumnName = "import date";
    private boolean _printHeadline;
    private CSVPrinter _csvPrinter;

    @Autowired
    public CSVExportGeneratedAccountsImportPostProcessor(Clock clock) {
        this._clock = clock;
    }

    @Override
    public boolean getIdentifiedByEmail() {
        return this._identifiedByEmail;
    }

    public void setIdentifiedByEmail(boolean identifiedByEmail) {
        this._identifiedByEmail = identifiedByEmail;
    }

    @Override
    public String getIdColumnName() {
        return this._idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this._idColumnName = idColumnName;
    }

    @Override
    public String getGivenNameColumnName() {
        return this._givenNameColumnName;
    }

    public void setGivenNameColumnName(String givenNameColumnName) {
        this._givenNameColumnName = givenNameColumnName;
    }

    @Override
    public String getSurnameColumnName() {
        return this._surnameColumnName;
    }

    public void setSurnameColumnName(String surnameColumnName) {
        this._surnameColumnName = surnameColumnName;
    }

    @Override
    public String getEmailColumnName() {
        return this._emailColumnName;
    }

    public void setEmailColumnName(String emailColumnName) {
        this._emailColumnName = emailColumnName;
    }

    @Override
    public String getPasswordColumnName() {
        return this._passwordColumnName;
    }

    public void setPasswordColumnName(String passwordColumnName) {
        this._passwordColumnName = passwordColumnName;
    }

    @Override
    public String getDateColumnName() {
        return this._dateColumnName;
    }

    public void setDateColumnName(String dateColumnName) {
        this._dateColumnName = dateColumnName;
    }

    @Override
    public String getOutputFilename() {
        return this._outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this._outputFilename = outputFilename;
    }

    @Override
    public void init() {
        try {
            this._csvPrinter = new CSVPrinter(this.getFileWriter(), FORMAT);
        }
        catch (IOException e) {
            PersonImportService.IMPORT_LOG.error("can't init postprocessor", (Throwable)e);
        }
    }

    @Nonnull
    private Appendable getFileWriter() throws IOException {
        String outputFilename = this.getOutputFilename();
        File file = new File(outputFilename);
        if (!file.exists()) {
            File directory = file.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IOException("output folder doesn't exist and can't be created! - " + directory.getAbsolutePath());
            }
            this._printHeadline = true;
        }
        if (!this.headerMatches(file)) {
            PersonImportService.IMPORT_LOG.info("found non matching headers in output file -> backup file and start new one....");
            this.backupFile();
            this._printHeadline = true;
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename, true), Charsets.UTF_8);
    }

    private void backupFile() throws IOException {
        String outputFilename = this.getOutputFilename();
        File file = new File(outputFilename);
        if (file.exists()) {
            File backupFile = new File(outputFilename + "." + BACKUP_FORMAT.print((ReadableInstant)this._clock.now()));
            FileUtils.moveFile((File)file, (File)backupFile);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean headerMatches(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void shutdown() {
        if (this._csvPrinter == null) {
            return;
        }
        try {
            this._csvPrinter.flush();
        }
        catch (IOException e) {
            PersonImportService.IMPORT_LOG.error("error while flushing output to file!", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this._csvPrinter);
        }
    }

    @Override
    public void process(List<? extends PersonImportModel<?>> models, ImportUpdateEventCollector events) {
        if (this._csvPrinter == null || models.isEmpty()) {
            return;
        }
        if (this._printHeadline) {
            ImmutableList<String> headers = this.getHeaders();
            try {
                this._csvPrinter.printRecord(headers);
            }
            catch (IOException e) {
                PersonImportService.IMPORT_LOG.error("error writing header to file: " + ERROR_JOINER.join(headers));
            }
            this._printHeadline = false;
        }
        for (PersonImportModel<?> model : models) {
            if (StringUtil.isBlank(model.getPlainPassword())) continue;
            try {
                this._csvPrinter.printRecord(this.getValues(model, false));
            }
            catch (IOException e) {
                PersonImportService.IMPORT_LOG.error("error writing import model to file: " + ERROR_JOINER.join(this.getValues(model, true)));
            }
        }
    }

    @Nonnull
    private ImmutableList<String> getHeaders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ImmutableList.of((Object)this.getIdColumnName(), (Object)this.getGivenNameColumnName(), (Object)this.getSurnameColumnName()));
        if (!this._identifiedByEmail) {
            builder.add((Object)this.getEmailColumnName());
        }
        builder.addAll((Iterable)ImmutableList.of((Object)this.getPasswordColumnName(), (Object)this.getDateColumnName()));
        return builder.build();
    }

    @Nonnull
    private ImmutableList<Object> getValues(PersonImportModel<?> model, boolean forLogging) {
        String currentDate = DATE_FORMAT.print((ReadableInstant)this._clock.now());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ImmutableList.of(model.getExternalId(), (Object)model.getPerson().getFirstName(), (Object)model.getPerson().getLastName()));
        if (!this._identifiedByEmail) {
            builder.add((Object)model.getImportedEmail());
        }
        builder.addAll((Iterable)ImmutableList.of((Object)(forLogging ? "********" : model.getPlainPassword()), (Object)currentDate));
        return builder.build();
    }
}

