/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.InternalLDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContext;
import de.justsoftware.onx.migration.business.impl.LDAPSearchContextIterator;
import de.justsoftware.onx.migration.business.impl.LDAPValueExtractor;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonImportModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.naming.directory.Attributes;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;

public abstract class AbstractLDAPMemberGroupImportDataProvider<P>
implements ImportProcessor.ImportDataProvider<LDAPPersonImportModel, P> {
    private LDAPValueExtractor<String> _memberValueExtractor;
    private InternalLDAPSearchContext _searchContext;

    @Required
    public void setMemberValueExtractor(@Nonnull LDAPValueExtractor<String> memberValueExtractor) {
        this._memberValueExtractor = memberValueExtractor;
    }

    @Required
    public void setSearchContext(@Nonnull LDAPSearchContext searchContext) {
        this._searchContext = InternalLDAPSearchContext.createFrom(searchContext);
    }

    @Override
    public Iterable<P> getAdditionalImportDataFor(List<? extends LDAPPersonImportModel> importedPersons) throws ImportException {
        Map<String, PersonId> personMapping = this.createPersonMapping(importedPersons);
        PersonImportService.IMPORT_LOG.info("Loading import models: {}", (Object)this.getClass().getName());
        Iterator ldapSearchContextIterator = LDAPSearchContextIterator.getImportModelsFromContext(this._searchContext, new MembershipAttributeMapper(personMapping));
        return Iterables.concat(() -> ldapSearchContextIterator);
    }

    @Nonnull
    protected abstract P mapMembersFromAttributes(@Nonnull ImmutableSet<PersonId> var1, @Nonnull Attributes var2);

    @Nonnull
    private Map<String, PersonId> createPersonMapping(@Nonnull List<? extends LDAPPersonImportModel> importedPersons) {
        HashMap personMapping = Maps.newHashMap();
        for (LDAPPersonImportModel lDAPPersonImportModel : importedPersons) {
            personMapping.put(lDAPPersonImportModel.getDN().toString().toLowerCase(), lDAPPersonImportModel.getPerson().getId());
        }
        return personMapping;
    }

    private class MembershipAttributeMapper
    extends AbstractContextMapper<P> {
        private final Map<String, PersonId> _personMapping;

        MembershipAttributeMapper(Map<String, PersonId> personMapping) {
            this._personMapping = personMapping;
        }

        protected P doMapFromContext(DirContextOperations contextOperations) {
            Attributes attrs = contextOperations.getAttributes();
            ImmutableSet memberAsPersonIds = (ImmutableSet)AbstractLDAPMemberGroupImportDataProvider.this._memberValueExtractor.getValues(attrs).stream().map(String::toLowerCase).map(this._personMapping::get).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            return AbstractLDAPMemberGroupImportDataProvider.this.mapMembersFromAttributes((ImmutableSet<PersonId>)memberAsPersonIds, attrs);
        }
    }
}

