/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.events.UpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.mail.business.ImportResultMailService;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.ImportPreProcessor;
import de.justsoftware.onx.migration.business.ImportProcessLockService;
import de.justsoftware.onx.migration.business.ImportProcessor;
import de.justsoftware.onx.migration.business.ImportService;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.model.ImportStatistics;
import de.justsoftware.onx.migration.shared.server.model.ImportModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractImportServiceImpl<T extends ImportModel>
implements ImportService {
    protected final PersonService _personService;
    protected final UpdateEventHandler _updateHandler;
    protected final JCEventBus _eventBus;
    protected final Clock _clock;
    protected final ImportProcessLockService _importProcessLockService;
    private final ImportResultMailService _mailService;
    private List<? extends ImportPostProcessor<? super T>> _postProcessorList = ImmutableList.of();
    private List<? extends ImportPreProcessor<? super T>> _preProcessorList = ImmutableList.of();

    public AbstractImportServiceImpl(PersonService personService, UpdateEventHandler updateEventHandler, JCEventBus eventBus, Clock clock, ImportResultMailService importResultMailService, ImportProcessLockService importProcessLockService) {
        this._personService = personService;
        this._updateHandler = updateEventHandler;
        this._eventBus = eventBus;
        this._clock = clock;
        this._mailService = importResultMailService;
        this._importProcessLockService = importProcessLockService;
    }

    protected abstract void initBeforeImport();

    protected abstract void cleanUpAfterImport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportStatistics doImport() {
        PersonImportService.IMPORT_LOG.info("****** IMPORT STARTED ({}) *********", (Object)this.getClass().getSimpleName());
        ImportStatistics statistics = new ImportStatistics(this._clock.now());
        ImportUpdateEventCollector eventCollector = new ImportUpdateEventCollector();
        if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
            PersonImportService.IMPORT_LOG.info("* Starting import at " + statistics.getStartTime().toString());
        }
        this.initBeforeImport();
        try {
            this.initProcessors();
            for (List<T> importModels : this.getImportModels(statistics)) {
                try {
                    if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
                        PersonImportService.IMPORT_LOG.info("Processing import batch of " + importModels.size() + " elements.");
                    }
                    this.preProcess(importModels);
                    List<T> toPostProcess = this.processBatch(importModels, statistics, eventCollector);
                    this.postProcess(toPostProcess, eventCollector);
                    statistics.incSuccessfulImports();
                }
                finally {
                    this.publishEvents(eventCollector);
                }
            }
        }
        catch (ImportException | RuntimeException e) {
            statistics.incFailedImports();
            PersonImportService.IMPORT_LOG.error("Import failed", (Throwable)e);
            this._mailService.notifyImportFailed(e.getMessage());
        }
        finally {
            this.shutDownProcessors();
            this.cleanUpAfterImport();
            statistics.setEndTime(this._clock.now());
            if (PersonImportService.IMPORT_LOG.isInfoEnabled()) {
                PersonImportService.IMPORT_LOG.info(statistics.getStatMessage());
            }
            PersonImportService.IMPORT_LOG.info("****** IMPORT FINISHED ({}) *********", (Object)this.getClass().getSimpleName());
        }
        return statistics;
    }

    private void publishEvents(ImportUpdateEventCollector eventCollector) {
        this._updateHandler.onChanges((Iterable<? extends UpdateEvent<?>>)eventCollector.getUpdateEvents());
        this._eventBus.post((Iterable<? extends ServerEvent>)eventCollector.getServerEvents());
        eventCollector.clear();
    }

    @Nonnull
    protected abstract List<T> processBatch(List<? extends T> var1, ImportStatistics var2, ImportUpdateEventCollector var3) throws ImportException;

    protected void initProcessors() {
        for (ImportProcessor processor : Iterables.concat(this._preProcessorList, this._postProcessorList)) {
            processor.init();
        }
    }

    protected void shutDownProcessors() {
        for (ImportProcessor processor : Iterables.concat(this._preProcessorList, this._postProcessorList)) {
            processor.shutdown();
        }
    }

    protected void postProcess(List<? extends T> importResult, ImportUpdateEventCollector eventCollector) {
        for (ImportPostProcessor<T> postProcessor : this._postProcessorList) {
            try {
                postProcessor.process(importResult, eventCollector);
            }
            catch (RuntimeException ex) {
                PersonImportService.IMPORT_LOG.error("Failed to post process batch of import models.", (Throwable)ex);
            }
        }
    }

    protected void preProcess(List<? extends T> importResult) {
        try {
            for (ImportPreProcessor<T> preProcessor : this._preProcessorList) {
                preProcessor.process(importResult);
            }
        }
        catch (RuntimeException ex) {
            PersonImportService.IMPORT_LOG.error("Failed to pre-process batch of import models.", (Throwable)ex);
        }
    }

    public void setImportPostProcessorList(List<? extends ImportPostProcessor<? super T>> postProcessorList) {
        this._postProcessorList = postProcessorList;
    }

    public void setImportPreProcessorList(List<? extends ImportPreProcessor<? super T>> preProcessor) {
        this._preProcessorList = preProcessor;
    }

    @Nonnull
    protected abstract Iterable<List<T>> getImportModels(ImportStatistics var1) throws ImportException;
}

