/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.migration.business.impl.IdMapper;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractIdMapper<T>
implements IdMapper<T> {
    private ImmutableSetMultimap<String, T> _idMap;

    @Required
    public void setIdMap(@Nonnull Map<String, Collection<String>> idMap) {
        ImmutableSetMultimap.Builder mapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Collection<String>> mapEntry : idMap.entrySet()) {
            mapBuilder.putAll((Object)mapEntry.getKey().toLowerCase(), this.createValuesFromStrings(mapEntry.getValue()));
        }
        this._idMap = mapBuilder.build();
    }

    protected abstract Collection<T> createValuesFromStrings(Collection<String> var1);

    @Override
    public ImmutableSet<T> getIdsByExternalKeys(String keys) {
        ImmutableSet result = this._idMap.get((Object)keys.toLowerCase());
        if (result == null || result.isEmpty()) {
            for (Map.Entry entries : this._idMap.asMap().entrySet()) {
                String wildcardKey = (String)entries.getKey();
                if (!keys.toLowerCase().matches(wildcardKey)) continue;
                return ImmutableSet.copyOf((Collection)((Collection)entries.getValue()));
            }
        }
        if (result == null) {
            return ImmutableSet.of();
        }
        return result;
    }
}

